import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableContainer,
  TablePagination,
  Paper,
} from "@mui/material";
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import EnhancedTableHead from "./MyTasksHeader/MyTasksHeader";
import moment from "moment";
import MyTaskToolBar from "../../components/MyTasksCompoments/MyTaskToolBar";
import { fetchAllTasks, deleteTask,editTask, deleteDateTimeTask} from "../../store/actions/tasksActions";
import NewTaskForm from "../../components/MyTasksCompoments/NewTaskForm";
import TableRowTask from "../../components/MyTasksCompoments/TableRowTask/TableRowTask";


export default function EnhancedTable() {
  const dispatch = useDispatch();

  const tasks = useSelector((state) => state.tasks.tasks);
  const user = useSelector((state) => state.users.user);
  const [recievedTasks, setRecievedTasks] = useState([]);
  const [addTaskForm, setAddTaskForm] = useState(false);
  const [order, setOrder] = useState("asc");
  const [orderBy, setOrderBy] = useState("id");
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [modal, setModal] = useState({
    open: false,
    task: null,
  });
  const [projects, setProjects] = useState(["1", "2"]);

  useEffect(() => {
    dispatch(fetchAllTasks());
    filterProjectsNamesFromTasks();
  }, [dispatch]);

  useEffect(() => {
    if (tasks && tasks?.length > 0) {
      setRecievedTasks(tasks);
      }
}, [dispatch, tasks?.length]);

  useEffect(() => {
    dispatch(fetchAllTasks());
  }, [addTaskForm, setAddTaskForm]);



  const handleRequestSort = ( property) => {
    const isAsc = orderBy === property && order === "asc";

    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const handleChangePage = ( newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onAuthorChange = (e, task) => {
    const value = e.target.value;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.author.displayName = value;
        updated.authorDisplayName = value;
        return updated;
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onDateChange = (id, value, property) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          [property]: moment.parseZone(value, "DD/MM/YY", true).format(),
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onProjectChange = (e, task) => {
    const value = e.target.value;
    const project = uniqueProjects.find((e) => e.id === value);
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.project = project;
        updated.projectName = project.title;
        return updated;
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onToggleEditMode = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: true,
          readOnly: false,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onToggleEditModeDone = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: false,
          readOnly: true,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const handleEditTask = (task) => {
    dispatch(editTask(task));
  };

  const deleteHandle = (id) => {
    dispatch(deleteTask(id));
  };

  const deleteDateTimeTaskHandle=(dateTimeTaskId)=>{
    console.log('delete by dateTimeTaskId ', dateTimeTaskId)
    dispatch(deleteDateTimeTask(dateTimeTaskId))
  }

  const handleEditDateTimeTask=(dateTimeTask)=>{
    console.log('edit by dateTImeTask')

    // dispatch(handleEditDateTimeTask(dateTimeTask))
  }
 
  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, id: task.id });
  };

  const handleClose = () => {
    setModal({ ...modal, open: false, id: null });
  };
  // ++++++++фильтрация по проектам+++++++++++++++

  const [projectName, setProjectName] = React.useState([]);
  const [filterProjectTumbler, setFilterProjectTumbler] = React.useState(false);

  const onClose = (projectName) => {
    let tasksFilteredByProject = tasks;
    if (projectName.length > 0) {
      tasksFilteredByProject = tasks.filter((task) =>
        projectName.includes(task.project?.title)
      );
    }
    setRecievedTasks(tasksFilteredByProject);
    setFilterProjectTumbler(true);
  };
  const rawProjects = tasks?.map((task) => task.project);

  const filterProjectsNamesFromTasks = () => {
    if (tasks && tasks?.length > 0) {
      let rawSetProjectNames = [];
      for (let project of rawProjects) {
        if (project === null) {
        } else {
          rawSetProjectNames.push(project.title);
        }
      }
      let uniqueTitlesProjects = [...new Set(rawSetProjectNames)];
      setProjects(uniqueTitlesProjects);
    }
  };

  const uniqueProjects = rawProjects?.reduce((results, value, index) => {
    const exist = results.find((v) => {
      return v !== null && v.id === value?.id;
    });
    if (!exist && value !== null) {
      results.push(value);
    }
    return results;
  }, []);

console.log('tasks', tasks)

  if (
    tasks &&
    tasks?.length > 0 &&
    recievedTasks &&
    recievedTasks?.length > 0
  ) {
    return (
      <Box sx={{ width: "fullwidth" }}>
        <Paper sx={{ width: "100%", mb: 2 }}>
          <MyTaskToolBar
            onClick={() => setAddTaskForm(!addTaskForm)}
            formStatus={addTaskForm}
            projects={projects}
            onClose={onClose}
            projectName={projectName}
            setProjectName={setProjectName}
          />

          {addTaskForm ? (
            <NewTaskForm
              projects={uniqueProjects}
              setAddTaskForm={() => setAddTaskForm(false)}
            />
          ) : null}

          <TableContainer>
            <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
              <EnhancedTableHead
                order={order}
                orderBy={orderBy}
                onRequestSort={handleRequestSort}
                rowCount={tasks.length}
              />
              <TableBody>
                {stableSort(recievedTasks, getComparator(order, orderBy))
                  .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                  .map((task, index) => {
                    return (
                      <TableRowTask
                      key ={index}
                      user={user}
                      task={task}
                      deleteHandle={deleteHandle}
                      handleEditTask ={handleEditTask}
                      handleEditDateTimeTask={handleEditDateTimeTask}
                      deleteDateTimeTask={deleteDateTimeTaskHandle}
                      onChange={onChange}
                      onModalOpen={onModalOpen}
                      onProjectChange={onProjectChange}
                      uniqueProjects={uniqueProjects}
                      onAuthorChange={onAuthorChange}
                      onDateChange={onDateChange}
                      onToggleEditMode={onToggleEditMode}
                      onToggleEditModeDone={onToggleEditModeDone}
                      />
                    
                    );
                  })}
              </TableBody>
            </Table>
          </TableContainer>
          <TablePagination
            rowsPerPageOptions={[5, 10, 25]}
            component="div"
            count={tasks.length}
            rowsPerPage={rowsPerPage}
            page={page}
            onPageChange={handleChangePage}
            onRowsPerPageChange={handleChangeRowsPerPage}
          />
        </Paper>
        <TaskModal
          task={recievedTasks.find((task) => task.id === modal.id)}
          open={modal.open}
          handleClose={handleClose}
          onChange={onChange}
          user={user}
        />
      </Box>
    );
  }
}

function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function stableSort(array, comparator) {
  const stabilizedThis = array?.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}
