import * as React from 'react';
import AppBar from '@mui/material/AppBar';
import Box from '@mui/material/Box';
import Toolbar from '@mui/material/Toolbar';
import Typography from '@mui/material/Typography';
import Button from '@mui/material/Button';
import MultipleSelect from '../UI/MultipleSelect/MultipleSelect';
import Add from "@mui/icons-material/Add";
import Close from "@mui/icons-material/Close";

export default function UsersTaskToolBar({projects,onClose,projectName,setProjectName,formStatus,onClick}) {
  
   let projectsFilter =
    <></>
   
    if (Array.isArray(projects))  {
      projectsFilter=   
      <MultipleSelect
      projects={projects}
      onClose={onClose}
      projectName={projectName}
      setProjectName={setProjectName}
      />
    }

  return (
    
    <Box sx={{ flexGrow: 1 }}>
      <AppBar position="static">
        <Toolbar>
         <Typography variant="h6" component="div" sx={{ flexGrow: 1 }}>
            Задачи сотрудников
          </Typography>
          {projectsFilter}

          <Button
            color={formStatus === true ? "info" : "inherit"}
            style={{
              backgroundColor: formStatus === true ? "white" : "inherit",
            }}
            onClick={onClick}
          >
            {formStatus === true ? (
              <>
                <Close />
                <span style={{ lineHeight: "16px" }}>Скрыть задачу</span>
              </>
            ) : (
              <>
                <Add />
                <span style={{ lineHeight: "16px" }}>Добавить задачу</span>
              </>
            )}
          </Button>
        
        </Toolbar>
      </AppBar>
    </Box>

    
  );
}
