import {Box, Button, Grid, Modal} from "@mui/material";
import {useState} from "react";
import { useSelector } from "react-redux";
import FormElement from "../../UI/Form/FormElement/FormElement";
import {Typography} from "@mui/material";

const style = {
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    width: 400,
    bgcolor: 'background.paper',
    border: '2px solid #000',
    boxShadow: 24,
    p: 4,
  };

const ProjectForm = ({onSubmit}) => {
    const users = useSelector(state => state.users)
    console.log(users)
    const [open, setOpen] = useState(false);
  const handleOpen = () => setOpen(true);
  const handleClose = () => setOpen(false);
    const [state, setState] = useState({
        title: ""
    });


    const submitFormHandler = (e) => {
        e.preventDefault();
        let project = {title: state.title}
        console.log(project);
        onSubmit(project);
        
    };

    const inputChangeHandler = (e) => {
        const {name, value} = e.target;
        setState(prevState => {
            return {...prevState, [name]: value};
        });
    };

    return (
        <div >
           
          <Button onClick={handleOpen} >Добавить проект</Button>
          <Modal
            open={open}
            onClose={handleClose}
            aria-labelledby="modal-modal-title"
            aria-describedby="modal-modal-description"
            onSubmit={submitFormHandler}
          >
            <Box sx={style}>
            <form >
        <Grid container direction="column" spacing={2}>
        <Typography variant="h4">Новый проект</Typography>
            <FormElement 
            onChange={inputChangeHandler} 
            name={"title"} 
            label={"Title"} 
            state={state}  
            />
            <Grid item>
                <Button
                    type="submit"
                    color="primary"
                    variant="contained"
                   
                >
                    Создать
                </Button>
            </Grid>
        </Grid>
    </form>
            </Box>
          </Modal>
        </div>
      );
    
};

export default ProjectForm;