const taskIsAvailableInCell = (task, hour, hourDiffEnd, hourDiff, hourFormat) => {
  if (((task.infoForCell.endHour <= hour || task.infoForCell.startHour  <= hour) && (task.infoForCell.endHour > hour))  
  || (!hourFormat && task.infoForCell.startHour >= hour  && task.infoForCell.endHour < hour + hourDiff)
  || (!hourFormat && task.infoForCell.startHour === hour + hourDiffEnd && task.infoForCell.endHour > hour)
  || (task.infoForCell.endMinute <= 59 && task.infoForCell.endHour === hour)) {
    return true
  } else {
    return false
  }
}

const lastPlaceInLineForTask = (task, hour, hourDiffEnd, hourFormat) => {
  if ((task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour + hourDiffEnd) || (!hourFormat && task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour)) {
    return true
  } else {
    return false
  }
}


export const getLinesInDay = (availableTasks, sortedTasks, hoursInDay, hours, hourFormat) => {
  let hourDiff
  let hourDiffEnd
  const lines = []
  if (hourFormat) {
    hourDiff = 1
    hourDiffEnd = 0
  } else {
    hourDiff = 2
    hourDiffEnd = 1
  }
  
  if (availableTasks.length) {
    lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
    for (let k = 0; k < sortedTasks.length; k++) {
      let skipLine = false
        for (let j = 0; j < lines.length; j++) {
          const line = lines[j]
          const task = sortedTasks[k]
          if (skipLine) {
            skipLine = false
            break;
          }
          for (let i = 0; i < line.length; i++) {
            const hour = hours[i]
            let havePlace = true
            if (taskIsAvailableInCell(task, hour, hourDiffEnd, hourDiff, hourFormat)) {
              if (!isNaN(line[i])) {
                for (let a = 0; a < hours.length; a++) {
                  const hour = hours[a]
                  if (lastPlaceInLineForTask(task, hour, hourDiffEnd, hourFormat)) {
                    if (isNaN(line[a])) {
                      havePlace = false
                      break;
                    }
                  }
                }
                if (!havePlace) {
                  if (j + 1 === lines.length) {
                    lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
                  }
                  havePlace = true  
                  break;
                }
                line[i] += `-${k}`
                if (lastPlaceInLineForTask(task, hour, hourDiffEnd, hourFormat)) {
                  skipLine = true
                  break;
                }
              } else {
                  if (j + 1 === lines.length) {
                    lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
                  }
                  break;
              }
            } 
          }
        }
    }
  }
  return lines
}

export const getSortedTasks = (availableTasks) => {
  if (availableTasks.length) {
    const newSortedArr = [...availableTasks].sort(function(a,b){
      const durattionFirstDate = a.infoForCell.endHour - a.infoForCell.startHour
      const durattionSecondDate = b.infoForCell.endHour - b.infoForCell.startHour
      return durattionSecondDate - durattionFirstDate;
    })
    return newSortedArr
  }
}

export const getAvailableTasks = (tasks, year, month, dayNumber) => {
  const tasksInDay = tasks.filter((task)=> {
    if (year === task.infoForCell.startYear) {
      if (month + 1 === task.infoForCell.startMonth) {
        if (dayNumber === task.infoForCell.startDay) {
              return task
          } else {return false}   
        } else {return false}   
      } else {return false}      
    })
    return tasksInDay
}

export const getBoxesInLine = (line, hoursInDay, sortedTasks) => {
  if (line) {
    let xs = 12/hoursInDay.length
    const boxes = []
    for (let i = 0; i < line.length; i++) {
      if (!isNaN(line[i])) {
        // if (boxes[boxes.length -1]?.task === null) {
        //   boxes[boxes.length -1].xs += xs
        // } else {
        boxes.push({xs: xs, task: null, hour: line[i]})
        //  }
      } else {
        const task = sortedTasks[line[i].split('-')[1]]
        const taskIsThere = boxes.find((taskFind)=>{
          if (taskFind?.task?.id === task.id) return taskFind
          return false
        })
        if (taskIsThere) {
          taskIsThere.xs +=xs
        } else {
          boxes.push({
            xs: xs, 
            task: sortedTasks[line[i].split('-')[1]]})
        }
      }
    }
    return boxes
  }
}