import { Autocomplete, Button, TextField } from "@mui/material";
import { memo } from "react";


function CalendarModalWorkerContent({ allUserProjects, onChangeProjectHandler, onChangeWorkerHandler, workerInfo, workers, handleClose, onChangeCalendarUser}) {
  return (<>
    <Autocomplete
      id="choose-project"
      freeSolo
      options={allUserProjects}
      getOptionLabel={(item) => item.title || ""}
      onChange={onChangeProjectHandler}
      name={"project"}
      value={workerInfo.project}
      renderInput={(params) => <TextField
        style={{ marginBottom: "15px" }}
        label={"Проект"}
        state={workerInfo.project}
        {...params} />}
    />
    {workerInfo.project ?
      <>
        <Autocomplete
          id="choose-worker"
          freeSolo
          options={workers}
          getOptionLabel={(item) => item?.user?.displayName || ""}
          onChange={(e, value) => { onChangeWorkerHandler(e, value) }}
          name={"worker"}
          value={workerInfo.worker}
          renderInput={(params) => <TextField
            label={"Участник"}
            state={workerInfo.worker}
            {...params} />}
        />
        <div style={{ display: 'flex', justifyContent: 'space-between', margin: '10px 0' }}>
          <Button onClick={()=>{onChangeCalendarUser()}} >Выбрать</Button>
          <Button onClick={() => handleClose()}>Отмена</Button>
        </div>
      </>
      : null}

  </>);
}

export default memo(CalendarModalWorkerContent);