import Paper from '@mui/material/Paper';
import UsersTasksTableToolbar from '../../components/UsersTasksCompoments/UsersTasksTableToolbar/UsersTasksTableToolbar';
import UsersTasksTablePagination from '../../components/UsersTasksCompoments/UsersTasksTablePagination/UsersTasksTablePagination';
import UsersTasksTableContainer from '../../components/UsersTasksCompoments/UsersTasksTableContainer/UsersTasksTableContainer';
import { activateCreateCopyTasksMode, addTaskToUserTasksTable, deleteDateTimeTaskUsers, deleteTaskUsers, editTaskUsers, fetchAllTasksByMembership, sortTaskByProjects } from '../../store/actions/tasksActions';
import { shallowEqual, useDispatch, useSelector } from 'react-redux';
import { useCallback, useEffect, useState } from 'react';
import { fetchAllUserProjects, fetchProjects } from '../../store/actions/projectsActions';
import moment from 'moment';
import { useNavigate } from 'react-router-dom';

export default function UsersTasks() {
  const dispatch = useDispatch();
  const navigate = useNavigate()

  const { tasks, sortedTasks } = useSelector((state) => state.tasks, shallowEqual);
  const { allUserProjectsForModalTask, projects } = useSelector(state => state.projects, shallowEqual)

  const [newTask, setNewTask] = useState({
    priority: '',
    title: '',
    project: '',
    description: '',
    executor: '',
    dateTimeDeadLine: null,
  })

  const [currentTask, setCurrentTask] = useState({
    priority: '',
    title: '',
    project: '',
    description: '',
    executor: '',
    dateTimeDeadLine: null,
  })

  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('createdAt');
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(10);
  const [addFormStatus, setAddFormStatus] = useState(false);
  const [projectIdListForTaskSelect, setProjectIdListForTaskSelect] = useState([]);
  const [activeTasksStatus, setActiveTasksStatus] = useState(false)

  useEffect(() => {
    dispatch(fetchAllTasksByMembership());
    dispatch(fetchAllUserProjects())
    dispatch(fetchProjects())
  }, [dispatch]);
  
  useEffect(() => {
    dispatch(sortTaskByProjects(projectIdListForTaskSelect, activeTasksStatus))
  }, [dispatch, projectIdListForTaskSelect, activeTasksStatus, tasks]);


  const onChangeNewTaskHandler = useCallback((e) => {
    const { value, name } = e.target;
    setNewTask((prevState => {
      return {
        ...prevState,
        [name]: value
      }
    }));
  }, [])

  const onChangeCurrentTaskHandler = useCallback((e) => {
    const { value, name } = e.target;
    setCurrentTask((prevState => {
      return {
        ...prevState,
        [name]: value
      }
    }));
  }, [])

  const onDateChangeEditHandler = useCallback((value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    setCurrentTask((prevState => {
      return {
        ...prevState,
        [property]: utcAvoidoffset
      }
    }));
  }, []);

  const onDateChangeHandler = useCallback((value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    setNewTask((prevState => {
      return {
        ...prevState,
        [property]: utcAvoidoffset
      }
    }));
  }, []);

  const handleRequestSort = useCallback((event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  }, [order, orderBy]);

  const handleChangePage = useCallback((event, newPage) => {
    setPage(newPage);
  }, []);

  const handleChangeRowsPerPage = useCallback((event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  }, []);

  const createTaskFromButtonHandler = useCallback(() => {
    if (addFormStatus) {
      setNewTask({
        priority: '',
        title: '',
        project: '',
        description: '',
        executor: '',
        dateTimeDeadLine: null
      })
    }
    setAddFormStatus((prevState) => { return !prevState })
  }, [addFormStatus])

  const createNewTaskHandler = useCallback(() => {
    if (newTask.priority === '' || newTask.project === '' || newTask.executor === '') {
      const task = {
        ...newTask,
        priority: newTask.priority ? newTask.priority : null,
        project: newTask.project ? newTask.project : null,
        executor: newTask.executor ? newTask.executor : null,
        dateTimeDeadLine: new Date(newTask.dateTimeDeadLine) instanceof Date && !isNaN(new Date(newTask.dateTimeDeadLine)) ? newTask.dateTimeDeadLine : null
      }
      dispatch(addTaskToUserTasksTable(task))
    } else {
      dispatch(addTaskToUserTasksTable(newTask))
    }
    setNewTask({
      priority: '',
      title: '',
      project: '',
      description: '',
      executor: '',
      dateTimeDeadLine: null
    })
    setAddFormStatus((prevState) => { return !prevState })
  }, [dispatch, newTask])


  const deleteTaskHandler = useCallback((id) => {
    dispatch(deleteTaskUsers(id))
  }, [dispatch])

  const deleteCopyTaskHandler = useCallback((id) => {
    dispatch(deleteDateTimeTaskUsers(id))
  }, [dispatch])

  const calendarOpen = useCallback((task) => {
    dispatch(activateCreateCopyTasksMode(task, navigate))
  }, [dispatch, navigate])

  const editCurrentTaskHandler = useCallback(() => {
    if (currentTask.priority === '' || currentTask.project === '' || currentTask.executor === '' || !Object.keys(currentTask.executor).length) {
      const task = {
        ...currentTask,
        priority: currentTask.priority ? currentTask.priority : null,
        project: currentTask.project ? currentTask.project : null,
        executor: currentTask.executor && currentTask.executor?.id ? currentTask.executor : null,
        dateTimeDeadLine: new Date(currentTask.dateTimeDeadLine) instanceof Date && !isNaN(new Date(currentTask.dateTimeDeadLine)) ? currentTask.dateTimeDeadLine : null
      }
      dispatch(editTaskUsers(task))
    } else {
      dispatch(editTaskUsers(currentTask))
    }
    setCurrentTask({
      priority: '',
      title: '',
      project: '',
      description: '',
      executor: '',
      dateTimeDeadLine: null
    })
  }, [dispatch, currentTask])

  const onCloseFilterByProjects = useCallback((listProjectIds) => {
    setProjectIdListForTaskSelect(listProjectIds)
  }, [])

  return (
    <Paper sx={{ width: '100%', mb: 2 }}>
      <UsersTasksTableToolbar
        addFormStatus={addFormStatus}
        createTaskFromButtonHandler={createTaskFromButtonHandler}
        onCloseFilterByProjects={onCloseFilterByProjects}
        projectIdListForTaskSelect={projectIdListForTaskSelect}
        setProjectIdListForTaskSelect={setProjectIdListForTaskSelect}
        projects={projects.projects}
        activeTasksStatus={activeTasksStatus}
        setActiveTasksStatus={setActiveTasksStatus}
      />
      <UsersTasksTableContainer
        order={order}
        orderBy={orderBy}
        handleRequestSort={handleRequestSort}
        rows={sortedTasks.length ? sortedTasks : tasks}
        page={page}
        rowsPerPage={rowsPerPage}
        addFormStatus={addFormStatus}
        onChangeNewTaskHandler={onChangeNewTaskHandler}
        newTask={newTask}
        allUserProjectsForModalTask={allUserProjectsForModalTask}
        onDateChangeHandler={onDateChangeHandler}
        createNewTaskHandler={createNewTaskHandler}
        deleteTaskHandler={deleteTaskHandler}
        calendarOpen={calendarOpen}
        deleteCopyTaskHandler={deleteCopyTaskHandler}
        currentTask={currentTask}
        setCurrentTask={setCurrentTask}
        onChangeCurrentTaskHandler={onChangeCurrentTaskHandler}
        onDateChangeEditHandler={onDateChangeEditHandler}
        editCurrentTaskHandler={editCurrentTaskHandler}
      />
      <UsersTasksTablePagination
        count={sortedTasks.length ? sortedTasks.length : tasks.length}
        rowsPerPage={rowsPerPage}
        page={page}
        handleChangePage={handleChangePage}
        handleChangeRowsPerPage={handleChangeRowsPerPage}
      />
    </Paper>
  );
}
