import { Box } from "@mui/material";
import { memo, useCallback } from "react";
import UserItem from "./UserItem/UserItem";

const styleList = {
  display: 'flex',
  gap: '10px',
  flexDirection: 'column',
  alignItems: 'center',
  height: '90%',
}

const UsersList = ({ role, members, deleteMemberHandler, currentRoleInProject, dragMemberToNewRole, setCurrentMember }) => {

  const dropHandler = (e) => {
    e.preventDefault();
    e.target.style.background = null
    setCurrentMember(null)
    dragMemberToNewRole(role)
  }

  const dragOverHandler = useCallback((e) => {
    e.preventDefault();
    e.target.style.background = '#d6d2d2'
  }, [])

  const dragLeaveHandler = useCallback((e) => {
    e.preventDefault();
    e.target.style.background = null
  }, [])

  return (
    <Box
      sx={styleList}
      onDrop={(e) => { dropHandler(e) }}
      onDragOver={(e) => { dragOverHandler(e) }}
      onDragLeave={(e) => { dragLeaveHandler(e) }}
      >
      {members.map((member) => {
        if (member.roleProject === role.value) {
          return (
            <UserItem
              key={member.id}
              user={member?.user}
              deleteMemberHandler={() => { deleteMemberHandler(member?.user?.id) }}
              role={role.value}
              currentRoleInProject={currentRoleInProject}
              dragMemberToNewRole={dragMemberToNewRole}
              setCurrentMember={setCurrentMember}
            />
          )
        } else {
          return null
        }
      })}
    </Box>
  );
};

export default memo(UsersList);