import moment from "moment"

export const getDaysInMonth = (dateNow) => {
  if (dateNow.month <= 11 && dateNow.month >= 0) {
    const newDaysInMonth = []
    const daysInMonthNumber = new Date(dateNow.year, dateNow.month + 1, 0).getDate()
    for (let i = 1; i <= daysInMonthNumber; i++) {
      const dayOfWeekNumber = new Date(dateNow.year, dateNow.month, i).getDay()
      const getDayOfWeekString = ["ВС","ПН","ВТ","СР","ЧТ","ПТ","СБ"][dayOfWeekNumber]
      newDaysInMonth.push({dayNumber: i, dayOfWeek: getDayOfWeekString})
    }
    return newDaysInMonth
  } else {
    return null
  }
}

export const getCurrentMonthString = (month) => {
  if (month <= 11 && month >= 0) {
    return ["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь", "Декабрь"][month];
  } else {
    return null
  }
}

export const dateToISOLikeButLocal = (date) => {
  if (date instanceof Date && !isNaN(date)) {
    const offsetMs = date.getTimezoneOffset() * 60 * 1000;
    const msLocal =  date.getTime() - offsetMs;
    const dateLocal = new Date(msLocal);
    const iso = dateLocal.toISOString();
    return iso;
  } else {
    return null
  }
}

export const getWeekFromCurrentDate = (year, month, curDay) => {
  const week = [0, 0, 0, 0, 0, 0, 0]
    const currentDayWeek = moment(new Date(year, month, curDay)).isoWeekday()
    for (let i = 1; i <= 7; i++) {
      if (currentDayWeek > i ) {
        const day = moment(new Date(year, month, curDay - i)).date()
        const dayWeek = moment(new Date(year, month, curDay - i)).isoWeekday()
        week[dayWeek - 1] = day
      } else if (currentDayWeek === i) {
        const day = moment(new Date(year, month, curDay)).date()
        const dayWeek = moment(new Date(year, month, curDay)).isoWeekday()
        week[dayWeek - 1] = day
      } else {
        const day = moment(new Date(year, month, curDay + i - moment(new Date(year, month, curDay)).isoWeekday())).date()
        const dayWeek = i - moment(new Date(year, month, curDay)).isoWeekday() + moment(new Date(year, month, curDay)).isoWeekday()
        week[dayWeek - 1] = day
      }
    }
    return week
}

export const getWeekInfoString = (week, date) => {
  if (week[0] > week[6]) {
    if (date.month === 11) {
      return getCurrentMonthString(date.month) + ' - ' + getCurrentMonthString(0) +  ' ' + date.year
    }
    return getCurrentMonthString(date.month) + ' - ' + getCurrentMonthString(date.month + 1) +  ' ' + date.year
  } else {
    return getCurrentMonthString(date.month) +  ' ' + date.year
  }
}