import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TablePagination,
  TableRow,
  Paper
} from "@mui/material";
import { useState } from "react";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import moment from "moment";
import CustomTableCell from "../../components/MyTasksCompoments/CustomTableCell";
import MaterialUIPickers from "../../components/MyTasksCompoments/DateTimePicker/DateTimePicker";
import BasicSelect from "../../components/UI/Select/Select";
import ProjectTasksHeader from "./ProjectTasksHeader";

export default function ProjectTasksBody({ tasks }) {

  const [order, setOrder] = useState("asc");
  const [orderBy, setOrderBy] = useState("id");
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(5);
  const [modal, setModal] = useState({
    open: false,
    task: null,
  });

  console.log(tasks)

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const handleChangePage = (event, newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };

  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, id: task.id });
  };

  const handleClose = () => {
    setModal({ ...modal, open: false, id: null });
  };

  const rawProjects = tasks?.map(task => task.project)

  if (
    tasks &&
    tasks?.length > 0
  ) {
    return (
      <Box sx={{ width: "fullwidth" }}>
        <Paper sx={{ width: "100%", mb: 2 }}>
          <TableContainer>
            <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
              <ProjectTasksHeader
                order={order}
                orderBy={orderBy}
                onRequestSort={handleRequestSort}
                rowCount={tasks.length}
              />
              <TableBody>

                {stableSort(tasks, getComparator(order, orderBy))
                  .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                  .map((task, index) => {
                    return (

                      <TableRow hover key={task.id}>
                        <TableCell
                          component="th"
                          scope="row"
                          padding="none"
                        ></TableCell>
                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "A", title: "A" },
                                { value: "B", title: "B" },
                                { value: "C", title: "C" },
                              ]}
                              task={task}
                              value={task.priority}
                              //   onChange={onChange}
                              name="priority"
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "priority",
                              value: task.priority,
                            }}
                          />
                        )}

                        <CustomTableCell
                          {...{
                            task,
                            name: "createdAt",
                            value: moment(task.createdAt)
                              .utc()
                              .format("DD-MM-YYYY hh:mm A"),

                          }}
                        />

                        <CustomTableCell
                          {...{
                            task,
                            name: "title",
                            value: task.title,
                            onModalOpen,
                          }}
                        />

                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={rawProjects.map((e) => ({
                                value: e?.id,
                                title: e?.title,
                              }))}
                              task={task}
                              name="project"
                              value={task.project?.id}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "projectId",
                              value: task.project?.title,
                            }}
                          />
                        )}

                        <CustomTableCell
                          {...{
                            task,
                            name: "author",
                            value: task.author.displayName,
                          }}
                        />

                        <TableCell>
                          <MaterialUIPickers
                            task={task}
                            name="dateTimeStart"
                          />
                        </TableCell>

                        <TableCell>
                          <MaterialUIPickers
                            task={task}
                            name="dateTimeDue"
                          />
                        </TableCell>

                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "opened", title: "opened" },
                                { value: "done", title: "done" },
                                { value: "failed", title: "failed" },
                              ]}
                              task={task}
                              name="accomplish"
                              value={task.accomplish}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "accomplish",
                              value: task.accomplish,
                            }}
                          />
                        )}
                      </TableRow>
                    );
                  })}
              </TableBody>
            </Table>
          </TableContainer>
          <TablePagination
            rowsPerPageOptions={[5, 10, 25]}
            component="div"
            count={tasks.length}
            rowsPerPage={rowsPerPage}
            page={page}
            onPageChange={handleChangePage}
            onRowsPerPageChange={handleChangeRowsPerPage}
          />
        </Paper>
        <TaskModal
          task={tasks.find((task) => task.id === modal.id)}
          open={modal.open}
          handleClose={handleClose}
        />
      </Box>
    );
  }
}


function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function stableSort(array, comparator) {
  const stabilizedThis = array?.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}

