import {Button, Menu, MenuItem} from "@mui/material";
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import {NavLink, useNavigate} from "react-router-dom";
import { logoutUser } from "../../../store/actions/usersActions";

const ProfileBlock = () => {
  const dispatch = useDispatch();
    const navigate = useNavigate()
    const [anchorEl, setAnchorEl] = useState(null);
    const open = Boolean(anchorEl);
    const user = useSelector(state => state.users.user)
 
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };

    const logout = () => {
        dispatch(logoutUser(navigate));
        handleClose()
    }
  return <>
      <Button
            color="inherit"
            onClick={handleClick}
            id='test_greetings'
        >
            Hello, {user?.displayName}
        </Button>
        <Menu
            anchorEl={anchorEl}
            open={open}
            onClose={handleClose}

        >
            <MenuItem component={NavLink} to="/profile/test" color="inherit" onClick={handleClose}>Profile</MenuItem>
            <MenuItem onClick={()=>{logout()}}>Logout</MenuItem>
        </Menu>
  </>
};

export default ProfileBlock;