import { TableCell, TextField, Tooltip } from "@mui/material";
import moment from "moment";
import { memo, useMemo } from "react";
import { accomplishStatuses, priorities } from "../../../../../../constants";
import CustomSelect from "../../../../../UI/СustomSelect/СustomSelect"
import { styled } from '@mui/material/styles';
import MaterialUIPickers from "../../../DateTimePicker/DateTimePicker";

const StyledTooltip = styled(({ className, ...props }) => (
  <Tooltip {...props} classes={{ popper: className }} />
))`
  & .MuiTooltip-tooltip {
    background: white;
  }
`;

function EditRow({ buttons, dateTimeTasks, onChangeCurrentTaskHandler, currentTask, allUserProjectsForModalTask, onDateChangeEditHandler, user }) {
  const workers = useMemo(() => {
    if (currentTask?.project) {
      currentTask.project = allUserProjectsForModalTask.find((project) => project?.value?.id === currentTask?.project?.id)?.value
      const arrUsers = currentTask?.project?.members.map((member) => { return { value: member.user, text: member.user.displayName } })
      arrUsers.push({ value: '', text: 'Никто' })
      return arrUsers
    } else {
      return [{ value: '', text: 'Выберите проект' }]
    }
  }, [allUserProjectsForModalTask, currentTask])

  return (
    <>
      <TableCell sx={{ width: '4%' }}>
        {user.id === currentTask.author.id ?
          <CustomSelect
            defaultValue={priorities[0]?.value}
            value={currentTask.priority}
            name={'priority'}
            variant={'outlined'}
            onChange={onChangeCurrentTaskHandler}
            id={'priority-type'}
            items={priorities}
            sx={{ width: '100%' }}
          />
          : currentTask.priority}
      </TableCell>

      <TableCell sx={{ width: '10%' }}>{moment(currentTask.createdAt).format('DD.MM.YYYY')}</TableCell>
      <Tooltip title={currentTask.description}>
        <TableCell sx={{ width: '25%', overflow: 'hidden', textOverflow: 'ellipsis' }}>
          {user.id === currentTask.author.id ?
            <StyledTooltip
              title={<TextField
                id="task-description"
                value={currentTask.description}
                variant="outlined"
                name='description'
                placeholder='Описание'
                sx={{ width: '300px' }}
                onChange={onChangeCurrentTaskHandler}
                multiline
                rows={5}

              />}>
              <TextField
                id="task-title"
                value={currentTask.title}
                variant="outlined"
                name='title'
                onChange={onChangeCurrentTaskHandler}
                sx={{ width: '90%' }}
              />
            </StyledTooltip>
            : currentTask.title}
        </TableCell>
      </Tooltip>
      <TableCell sx={{ width: '10%' }}>
        {user.id === currentTask.author.id ?
          <CustomSelect
            value={currentTask.project}
            name={'project'}
            variant={'outlined'}
            onChange={onChangeCurrentTaskHandler}
            id={'project'}
            items={allUserProjectsForModalTask}
            sx={{ width: '100%' }}
          />
          : currentTask.projectTitle}
      </TableCell>
      <TableCell sx={{ width: '8%' }}>
        {user.id === currentTask.author.id ?
          <CustomSelect
            value={currentTask.executor}
            name={'executor'}
            variant={'outlined'}
            onChange={onChangeCurrentTaskHandler}
            renderValue={(executor)=>executor?.displayName}
            id={'executor'}
            items={workers}
            sx={{ width: '100%' }}
          />
          : currentTask.executorName}
      </TableCell>
      <TableCell sx={{ width: '8%' }}>{currentTask.authorName}</TableCell>

      <TableCell sx={{ width: '13%' }}>
        {dateTimeTasks}
      </TableCell>

      <TableCell sx={{ width: '12%' }}>
        {user.id === currentTask.author.id ?
          <MaterialUIPickers
            task={currentTask}
            name="dateTimeDeadLine"
            onChange={onDateChangeEditHandler}
            currentTask={true}
          />
          : currentTask.dateTimeDeadLine ? moment(currentTask.dateTimeDeadLine).utc().format('DD.MM.YYYY HH:MM') : null}
      </TableCell>
      <TableCell sx={{ width: '7%' }}>
        <CustomSelect
          value={currentTask.accomplish}
          name={'accomplish'}
          variant={'outlined'}
          onChange={onChangeCurrentTaskHandler}
          id={'accomplish'}
          items={accomplishStatuses}
          sx={{ width: '100px' }}
        />
      </TableCell>
      <TableCell size='medium' sx={{ width: '5%', position: 'relative' }}>
        {buttons}
      </TableCell>
    </>)
}

export default memo(EditRow)