import { FormControl, InputLabel, MenuItem, Select } from '@mui/material';
import { memo } from 'react';

function СustomSelect({ value, onChange, label, variant = 'standard', items, id, defaultValue, name, sx, renderValue}) {
  return (
    <>
      <FormControl variant={variant} sx={ sx?.width ? sx : { m: 0, minWidth: 125}}>
        <InputLabel id={`${id}-select-label`}>{label}</InputLabel>
        <Select
          labelId={`${id}-select-label`}
          id={`${id}-select`}
          value={value}
          renderValue={renderValue ? renderValue : null} 
          onChange={onChange}
          label={label}
          name={name}
          defaultValue={defaultValue}
        >
          {items.map((item, i) => {
            return (
              <MenuItem
                key={i}
                value={item?.value}
              >{item?.text}</MenuItem>
            )
          })}
        </Select>
      </FormControl>
    </>);
}

export default memo(СustomSelect, (prevProps, nextProps) => {
  if (prevProps.value !== nextProps.value || prevProps.items !== nextProps.items) {
    return false
  } else {
    return true
  }
});