import { Button } from "@mui/material";
import { Box } from "@mui/system";
import { memo } from "react";
import FormElement from "../../UI/Form/FormElement/FormElement"
import { isValidate } from "./helpers";


const NewProjectModalContent = ({ inputChangeHandler, projectTitle, createNewProjectHandler, handleClose }) => {


  return <>
    <FormElement
      onChange={(e)=>{inputChangeHandler(e)}}
      name={"title"}
      label={"Название"}
      state={projectTitle}
    />
    <Box sx={{ display: 'flex', justifyContent: 'space-between', marginTop: '10px'}}>
      <Button
        type="submit"
        color="primary"
        variant="outlined"
        onClick={()=>{createNewProjectHandler()}}
        disabled={!isValidate(projectTitle)}
      >
        Создать
      </Button>
      <Button
        type="submit"
        color="primary"
        variant="outlined"
        onClick={()=>{handleClose()}}
      >
        Отмена
      </Button>
    </Box>
  </>
};

export default memo(NewProjectModalContent);