import {Table, TableContainer, } from "@mui/material";
import { memo } from "react";
import MyTaskNewTaskForm from "./MyTaskNewTaskForm/MyTaskNewTaskForm";
import MyTasksTableBody from "./MyTasksTableBody/MyTasksTableBody";
import MyTasksTableHead from "./MyTasksTableHead/MyTasksTableHead";


function MyTasksTableContainer({ order, orderBy, handleRequestSort, rows, page, rowsPerPage, addFormStatus, onChangeNewTaskHandler, newTask, allUserProjectsForModalTask, onDateChangeHandler, createNewTaskHandler, deleteTaskHandler, calendarOpen, deleteCopyTaskHandler, currentTask, setCurrentTask, onChangeCurrentTaskHandler, onDateChangeEditHandler, editCurrentTaskHandler}) {
  return (
    <TableContainer>
      <MyTaskNewTaskForm
        addFormStatus={addFormStatus}
        onChangeNewTaskHandler={(e)=>{onChangeNewTaskHandler(e)}}
        newTask={newTask}
        allUserProjectsForModalTask={allUserProjectsForModalTask}
        onDateChangeHandler={onDateChangeHandler}
        createNewTaskHandler={()=>{createNewTaskHandler()}}
      />
      <Table
        sx={{ minWidth: 750 }}
        aria-labelledby="tableTitle"
      >
        <MyTasksTableHead
          order={order}
          orderBy={orderBy}
          handleRequestSort={handleRequestSort}
          deleteTaskHandler={deleteTaskHandler}
        />
        <MyTasksTableBody
          order={order}
          orderBy={orderBy}
          rows={rows}
          page={page}
          rowsPerPage={rowsPerPage}
          deleteTaskHandler={deleteTaskHandler}
          calendarOpen={calendarOpen}
          deleteCopyTaskHandler={deleteCopyTaskHandler}
          currentTask={currentTask}
          setCurrentTask={setCurrentTask}
          onChangeCurrentTaskHandler={onChangeCurrentTaskHandler}
          allUserProjectsForModalTask={allUserProjectsForModalTask}
          onDateChangeEditHandler={onDateChangeEditHandler}
          editCurrentTaskHandler={editCurrentTaskHandler}
        />
      </Table>
    </TableContainer>
  );
}

export default memo(MyTasksTableContainer)