import { AppBar, Toolbar } from '@mui/material';
import { Box } from '@mui/system';
import { memo } from 'react';
import ButtonSwapCalendar from '../../UI/ButtonSwapCalendar/ButtonSwapCalendar';
import CalendarUserDisplayName from '../../UI/CalendarUserDisplayName/CalendarUserDisplayName';
import WeekCalendarHeaderInfo from './WeekCalendarHeaderInfo/WeekCalendarHeaderInfo';




function WeekCalendarHeader({ decrementWeek, incrementWeek, weekInfo, onChangeWeekGoalHandler, handleOpen, currentCalendarDisplayName, user, userId }) {

  return (
    <>
      <Box sx={{ flexGrow: 1 }}>
        <AppBar position="static">
          <Toolbar>
            <Box sx={{ display: 'flex', flexDirection: 'column', gap: 1 }}>

              <CalendarUserDisplayName
                currentCalendarDisplayName={currentCalendarDisplayName}
              />

              <WeekCalendarHeaderInfo
                decrementWeek={decrementWeek}
                incrementWeek={incrementWeek}
                weekInfo={weekInfo}
                onChangeWeekGoalHandler={onChangeWeekGoalHandler}
              />

            </Box>
            <ButtonSwapCalendar
              user={user}
              userId={userId}
              handleOpen={handleOpen}
             />
          </Toolbar>
        </AppBar>
      </Box>
    </>
  );
}

export default memo(WeekCalendarHeader);