import { Grid } from "@mui/material";
import { memo, useEffect, useMemo, useRef, useState } from "react";
import { getHoursInDayNumbers, getAvailableTasks, getLinesInDay, getSortedTasks } from "../../../../../helpers/CalendarHelpers";
import CalendarStandartCell from "../../../UI/CalendarStandartCell/CalendarStandartCell";
import CalendarTask from "../CalendarTask/CalendarTask";
import { getTasksWithInfoForPosition } from "./Helpers";

const CalendarRowDay = ({ xs, hoursInDay, createTaskInCellHandler, currentTask, handleOpen, modal, setCurrentTask, year, month, tasks, day, hourFormat, dragTaskHandler, createCopyTask, setCopyTask, copyTask }) => {

  const [rowDaySize, setRowDaySize] = useState({ width: 0, height: 0 })
  const dayRowRef = useRef('')
  useEffect(() => {
    setRowDaySize(prev => { return { height: dayRowRef.current.offsetHeight, width: dayRowRef.current.offsetWidth } })
  }, [hourFormat])

  const hours = useMemo(() => {
    return getHoursInDayNumbers(hoursInDay)
  }, [hoursInDay])

  const availableTasks = useMemo(() => {
    return getAvailableTasks(tasks, year, month, day.dayNumber)
  }, [tasks, month, year, day.dayNumber])

  const sortedTasks = useMemo(() => {
    return getSortedTasks(availableTasks)
  }, [availableTasks])

  const linesInDay = useMemo(() => {
    return getLinesInDay(availableTasks, sortedTasks, hoursInDay, hours, hourFormat)
  }, [availableTasks, hourFormat, hours, hoursInDay, sortedTasks])

  return <>
    <Grid
      container
      item
      xs={10.8}
      align='center'
      sx={{ position: 'relative' }}
      ref={dayRowRef}
    >
      {linesInDay?.map((line, i) => {
        const tasks = getTasksWithInfoForPosition(line, hoursInDay, sortedTasks, i, rowDaySize.width)
        return (tasks.map((task) => {
            const step = rowDaySize.width / hoursInDay.length
            return (
              <CalendarTask
                key={task.task.id}
                width={task.width}
                left={task.left}
                task={task.task}
                top={task.top}
                handleOpen={handleOpen}
                setCurrentTask={setCurrentTask}
                modal={modal}
                month={month}
                setCopyTask={setCopyTask}
                dragTaskHandler={dragTaskHandler}
                hourFormat={hourFormat}
                step={step}
              >
              </CalendarTask>
            )
          })
        )

      })}
      {hoursInDay.map((hour, i) => {
        return (
          <CalendarStandartCell
            linesInDay={linesInDay}
            key={i}
            item xs={xs}
            createTaskInCellHandler={createTaskInCellHandler}
            hours={hour}
            dragTaskHandler={dragTaskHandler}
            dayNumber={day.dayNumber}
            currentTask={currentTask}
            handleOpen={handleOpen}
            modal={modal}
            copyTask={copyTask}
            createCopyTask={createCopyTask}
            month={month}
            year={year}
          >
          </CalendarStandartCell>
        )
      })}
    </Grid>
  </>
};

export default memo(CalendarRowDay, (prevProps, nextProps) => {
  if (!prevProps.modal) return false
  if (nextProps.modal) return true
});

