import * as React from "react";
import {
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableRow,
  TableHead,
  IconButton,
  Tooltip,
  Typography,
  Divider,
} from "@mui/material";
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { AddBox } from "@mui/icons-material";
import moment from "moment";
import CustomTableCell from "./CustomTableCell";
import MaterialUIPickers from "./DateTimePicker/DateTimePicker";
import BasicSelect from "../UI/Select/Select";
import { addTaskToUserTasksTable } from "../../store/actions/tasksActions";
import TaskModal from "./TaskModal/TaskModal";

export default function NewTaskForm({
  projects,
  currentProject,
  setCurrentProject,
  setAddTaskForm,
}) {
  const dispatch = useDispatch();
  const user = useSelector((state) => state.users.user);
  const currentDateTime = new Date();
  const dateTime = moment(currentDateTime).utc().format();
  const [task, setTask] = useState({
    id: 0,
    title: "",
    description: "",
    createdAt: dateTime,
    dateTimeStart: null,
    dateTimeDeadLine: null,
    dateTimeTasks: [],
    dateTimeDue: null,
    project: null,
    accomplish: "opened",
    priority: "B",
    author: { id: user.id },
    authorDisplayName: user.displayName,
    executor:null,
    isEditMode: true,
  }); 
  const [modal, setModal] = useState(false);
  console.log('NewTaskForm currentProject ', currentProject )

  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal(true);
  };

  const handleClose = () => {
    setModal(false);
  };

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const newTask = { ...task, [name]: value };
    setTask(newTask);
  };

  const onProjectChange = (e, task) => {
    const value = e.target.value;
    const project = projects.find((project) => project.id === value);
    setCurrentProject(project)
    const newTask = { ...task };
    newTask.project = project;
    setTask(newTask);
  };

  const onExecutorChange = (e, task) => {
    const {value, name} = e.target.value;
    let executorMember = null
    const newTask = { ...task };
    if( name==='executor' && value!==null) {
      executorMember = currentProject.find((member) => member.user.id === value);
      newTask.executor = executorMember?.user;
    }
    setTask(newTask);
  };

  const onDateChange = (id, value, property) => {
    const newTask = {
      ...task,
      [property]: moment.parseZone(value, "DD/MM/YYYY", true).format(),
    };
    setTask(newTask);
  };

  const handleAddTask = () => {
    dispatch(addTaskToUserTasksTable(task));
    setAddTaskForm();
  };

  return (
    <>
      <Divider>
        <Typography variant="overline">Добавить новую задачу</Typography>
      </Divider>
      <TableContainer
        style={{
          backgroundColor: "#E8E8E8",
          marginBottom: "2em",
        }}
      >
        <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
          <TableHead>
            <TableRow>
              {header.map((headCell) => (
                <TableCell
                  key={headCell.id}
                  align="center"
                  padding={headCell.disablePadding ? "none" : "normal"}
                  colSpan={headCell.colSpan}
                >
                  {headCell.label}
                </TableCell>
              ))}
            </TableRow>
          </TableHead>

          <TableBody>
            <TableRow hover key={task.id}>
              <TableCell component="th" scope="row" padding="none"></TableCell>
              <TableCell>
                <BasicSelect
                  items={[
                    { value: "A", title: "A" },
                    { value: "B", title: "B" },
                    { value: "C", title: "C" },
                  ]}
                  task={task}
                  value={task.priority}
                  onChange={onChange}
                  name="priority"
                />
              </TableCell>

      
              <CustomTableCell
                colSpan={3}
                {...{
                  task,
                  name: "title",
                  value: task.title,
                  onModalOpen,
                  user: user,
                  placeholder: "Кликните для ввода информации по задаче"
                }}
              />
              
              <TableCell>
                <BasicSelect
                  items={projects?.map((project) => ({
                    value: project?.id,
                    title: project?.title,
                  }))}
                  task={task}
                  onChange={onProjectChange}
                  name="project"
                  value={task.project?.id}
                />
              </TableCell>
              <TableCell>
                <BasicSelect
                  items={currentProject?currentProject?.members.map((member) => ({
                    value: member?.user?.id,
                    title: member?.user?.displayName,
                  })):null}
                  task={task}
                  onChange={onExecutorChange}
                  name="executor"
                  value={task.executor?.id}
                  defaultValue={user.id}
                />
              </TableCell>

    

              <TableCell>
                <MaterialUIPickers
                  task={task}
                  name="dateTimeDeadLine"
                  onChange={onDateChange}
                />
              </TableCell>

              <TableCell>
                <Tooltip title="Добавить">
                  <IconButton size="large" onClick={handleAddTask}>
                    <AddBox fontSize="large" />
                  </IconButton>
                </Tooltip>
              </TableCell>
            </TableRow>

          </TableBody>
        </Table>
        <TaskModal
              task={task}
              open={modal}
              handleClose={handleClose}
              onChange={onChange}
              user={user}
            />
      </TableContainer>
      <Divider />
    </>
  );
}

export const header = [
  {
    id: "id",
    numeric: true,
    disablePadding: true,
    label: "",
  },
  {
    id: "priority",
    numeric: false,
    disablePadding: true,
    label: "Приоритет",
  },
{
    id: "title",
    numeric: false,
    disablePadding: false,
    label: "Заголовок",
    colSpan:3
  },
  {
    id: "projectName",
    numeric: true,
    disablePadding: false,
    label: "Проект",
  },
  {
    id: "executorName",
    numeric: false,
    disablePadding: false,
    label: "Исполнитель",
  },
  {
    id: "dateTimeDeadLine",
    numeric: true,
    disablePadding: false,
    label: "Дедлайн",
  },

  {
    id: "add",
    numeric: false,
    disablePadding: false,
    label: "",
  },
];
