import {Grid} from "@mui/material";
import ProjectMembersItem from "../ProjectMembersItem/ProjectMembersItem";

const ProjectMembersList = ({members, roleProjectOfAuthor, authorOfProject}) => {
    console.log("members ", members)
    return (
        <Grid item container direction="column" spacing={1}>
            {members?.map(member => {
                return <ProjectMembersItem
                    displayName={member?.user?.displayName}
                    roleProject={member?.roleProject}
                    id={member.id}
                    key={member.id}
                    roleProjectOfAuthor={roleProjectOfAuthor}
                    userId={member?.user?.id}
                    members={members}
                    authorOfProject={authorOfProject}
                />
            })}
        </Grid>
    );
};

export default ProjectMembersList;