import { Button, Card, CardActions, CardContent, Grid, IconButton } from "@mui/material";
import { Link } from "react-router-dom";
import ArrowForwardIcon from "@mui/icons-material/ArrowForward";
import { useDispatch, useSelector } from "react-redux";
import DeleteIcon from "@mui/icons-material/Delete";
import { deleteProject } from "../../../store/actions/projectsActions";

const ProjectItem = ({ title, tasks, projectId }) => {
    const user = useSelector(state => state.users.user);
    const dispatch = useDispatch();

    console.log(user)

    const deleteHandle = (projectId) => {
        console.log("project id", projectId)
        dispatch(deleteProject(projectId))
    };

    return <>
        <Grid item xs={12} sm={12} md={6} lg={4}>
            <Card>
                <CardContent >
                    <strong>
                        <br></br>
                        Название проекта: {title}
                    </strong>
                    <strong>
                        <br></br>
                        {/* Задачи: {tasks} */}
                    </strong>
                </CardContent>
                <CardActions>
                    {(title !== "Личные дела") ? <Button onClick={() => {
                        deleteHandle(projectId);
                    }} variant="outlined" startIcon={<DeleteIcon />}>
                        Delete
                    </Button> : null}
                    <IconButton component={Link} to={"/projects/" + projectId}>
                        <ArrowForwardIcon />
                    </IconButton>

                </CardActions>
            </Card>
        </Grid>
    </>
};

export default ProjectItem;
