import { Box } from '@mui/system';
import { Typography } from '@mui/material';
import { memo } from 'react';
import WeekPriority from './WeekPriority/WeekPriority';



function WeekPriorities({ weekPriorities, onChangeWeekPrioritiesHandler }) {
  return (
    <>

      <Box>
        <Typography variant='h5' sx={{ display: 'flex', flexDirection: 'column' }}>
          Приоритеты:
          {Object.values(weekPriorities).map((priority, i)=>{
            return (
            <WeekPriority
              key={i}
              onChangeWeekPrioritiesHandler={(e)=>{onChangeWeekPrioritiesHandler(e)}}
              priorityName={Object.keys(weekPriorities)[i]}
              priority={priority}
              number={i+1}
            />
            )
          })}
        </Typography>

      </Box>

    </>
  );
}

export default memo(WeekPriorities);