import { Box } from '@mui/system';
import { TextField, Typography } from '@mui/material';
import { memo, useCallback, useState } from 'react';



function WeekGoal({ weekGoal, onChangeWeekGoalHandler }) {
  const [goalEditCheck, setGoalEditCheck] = useState(false)
  const onClickGoalHandler = useCallback(() => {
    setGoalEditCheck(true)
  }, [])
  return (
    <>

      <Box sx={{ display: 'flex', alignItems: 'center', gap: '10px' }}>
        {goalEditCheck ?
          <>
            <Typography variant='h5' sx={{ marginTop: '20px' }}>
              Цель недели:
            </Typography>
            <TextField
              id="week-gaol"
              value={weekGoal}
              variant="standard"
              sx={{ input: { color: 'white', fontSize: '22px', fontWeight: '400', paddingTop: '25px' } }}
              InputProps={{
                disableUnderline: true,
              }}
              name='weekGoal'
              autoFocus
              onBlur={() => { setGoalEditCheck(false) }}
              onChange={(e) => { onChangeWeekGoalHandler(e) }}
            />
          </>
          : <Typography variant='h5' onClick={() => { onClickGoalHandler() }} sx={{ marginTop: '20px' }}>Цель недели: {weekGoal}</Typography>
        }
      </Box>

    </>
  );
}

export default memo(WeekGoal);