import { AppBar, Toolbar } from '@mui/material';
import { Box } from '@mui/system';
import { memo } from 'react';
import ButtonSwapCalendar from '../../UI/ButtonSwapCalendar/ButtonSwapCalendar';
import CalendarUserDisplayName from '../../UI/CalendarUserDisplayName/CalendarUserDisplayName';
import WeekCalendarHeaderInfo from './WeekCalendarHeaderInfo/WeekCalendarHeaderInfo';
import WeekGoal from './WeekGoal/WeekGoal';
import WeekPriorities from './WeekPriorities/WeekPriorities';




function WeekCalendarHeader({ decrementWeek, incrementWeek, weekInfo, weekGoal, onChangeWeekGoalHandler, weekPriorities, onChangeWeekPrioritiesHandler, handleOpen, currentCalendarDisplayName, user, userId }) {

  return (
    <>
      <Box sx={{ flexGrow: 1 }}>
        <AppBar position="static">
          <Toolbar>
            <Box sx={{ display: 'flex', flexDirection: 'column', gap: 1 }}>

              <CalendarUserDisplayName
                currentCalendarDisplayName={currentCalendarDisplayName}
              />
              <WeekGoal
                weekGoal={weekGoal}
                onChangeWeekGoalHandler={onChangeWeekGoalHandler}
              />

              <WeekPriorities
                weekPriorities={weekPriorities}
                onChangeWeekPrioritiesHandler={onChangeWeekPrioritiesHandler}
              />

              <WeekCalendarHeaderInfo
                decrementWeek={decrementWeek}
                incrementWeek={incrementWeek}
                weekInfo={weekInfo}
                weekGoal={weekGoal}
                onChangeWeekGoalHandler={onChangeWeekGoalHandler}
              />

            </Box>
            <ButtonSwapCalendar
              user={user}
              userId={userId}
              handleOpen={handleOpen}
             />
          </Toolbar>
        </AppBar>
      </Box>
    </>
  );
}

export default memo(WeekCalendarHeader);