import { useMemo } from "react";
import { getHoursInDayNumbers, getAvailableTasks, getLinesInDay, getSortedTasks } from "../../../../../helpers/CalendarHelpers";
import CalendarStandartCell from "../../../UI/CalendarStandartCell/CalendarStandartCell";
import { useEffect, useRef, useState } from "react";
import { Grid } from "@mui/material";
import CalendarWeekTask from "./CalendarWeekTask/CalendarWeekTask";
import { getTasksWithInfoForPosition, getWidthLeftZIndex } from "./Helpers";



function CalendarColumnDayWeek({ hoursInDay, tasks, month, year, day, hourFormat, handleOpen, setCurrentTask, copyTask, setCopyTask, createCopyTask, createTaskInCellHandler, modal, dragTaskHandler, copyMode, deleteTaskHandler }) {

  const [columnDaySize, setColumnDaySize] = useState({ width: 0, height: 0 })

  const dayColumnRef = useRef('')
  useEffect(() => {
    setColumnDaySize(prev => { return { height: dayColumnRef.current.offsetHeight, width: dayColumnRef.current.offsetWidth } })
  }, [hourFormat])
  
  const hours = useMemo(() => {
    return getHoursInDayNumbers(hoursInDay)
  }, [hoursInDay])

  const availableTasks = useMemo(() => {
    return getAvailableTasks(tasks, year, month, day)
  }, [tasks, month, year, day])


  const sortedTasks = useMemo(() => {
    return getSortedTasks(availableTasks)
  }, [availableTasks])


  const linesInDay = useMemo(() => {
    return getLinesInDay(availableTasks, sortedTasks, hoursInDay, hours, hourFormat)
  }, [availableTasks, hourFormat, hours, hoursInDay, sortedTasks])

  return (<>
    <Grid item xs={12 / 7} ref={dayColumnRef} sx={{ position: 'relative' }}>
      {linesInDay?.map((line, i) => {
        const boxes = getTasksWithInfoForPosition(line, sortedTasks, linesInDay, columnDaySize.height, hours)
        return (<>
          {boxes.map((task) => {
            const { width, left, zIndex } = getWidthLeftZIndex(task, columnDaySize.width, i)
            const step = columnDaySize.height / hours.length
            const tasksLength = task.tasksInHour
            return (
              <CalendarWeekTask
                key={task.task.id}
                width={width}
                height={task.height}
                left={left}
                task={task.task}
                top={task.top}
                zIndex={zIndex}
                handleOpen={handleOpen}
                setCurrentTask={setCurrentTask}
                modal={modal}
                month={month}
                setCopyTask={setCopyTask}
                dragTaskHandler={dragTaskHandler}
                step={step}
                tasksLength={tasksLength}
                hourFormat={hourFormat}
                copyModeTask={copyMode.task}
                deleteTaskHandler={deleteTaskHandler}
              >
              </CalendarWeekTask>
            )
          })}
        </>)

      })}
      {hoursInDay?.map((hour, i) => {
        return (
          <CalendarStandartCell
            key={i}
            week={true}
            createTaskInCellHandler={createTaskInCellHandler}
            handleOpen={handleOpen}
            dayNumber={day}
            hours={hour}
            modal={modal}
            copyTask={copyTask}
            createCopyTask={createCopyTask}
            month={month}
            year={year}
            dragTaskHandler={dragTaskHandler}
            copyMode={copyMode.working}
            copyModeTask={copyMode.task}
          >
          </CalendarStandartCell>
        )
      })}
    </Grid>

  </>);
}

export default CalendarColumnDayWeek;