import express,{Router, Request, Response} from 'express';
import {User} from '../models/User';
import {myDataSource} from '../app-data-source';
import { nanoid } from 'nanoid';
import { PasswordRecovery } from '../models/PasswordRecovery';
import { transporter } from '../helpers';
import {FRONTEND_URL} from "../helpers";
import {SALT_WORK_FACTOR} from "../models/User";
import bcrypt from 'bcrypt';
const router:Router = express.Router();
const dataSource = myDataSource;


/**Make requiest to init recovery process */
router.post ('/', async (req:Request, res:Response):Promise<void |Response>=>{
    const {email} = req.body 
    console.log("emeil", email)
    const user = await dataSource
    .getRepository(User)
    .findOne({
        where:{
            email:email
        }
    })
    console.log('user ', user)
    if (!user) return res.status(404).send({message:'user not found'})
    const token = nanoid();
    try{
        const passwordRecovery = new PasswordRecovery()
        passwordRecovery.user= user; 
        passwordRecovery.token=token;
        await passwordRecovery.save()
        console.log('passwordRecover ' , passwordRecovery)
        const url = `${FRONTEND_URL}/reset-password/${token}`;
        await transporter.sendMail({
            from:"planner45@yandex.com",
            to: `${email}`,
            subject:"Запрос на восстановление пароля",
            text:`Вы отправили запрос на восстановление пароля, 
            перейдите по ссылке плз:{url}`,
            html:`Вы отправили запрос на восстановление пароля,
             перейдите по ссылке плз: <br><a> href="${url}">${url}</a>`});
            return res.send({message:'Email successffuly send'})
    } catch (e){ 
        console.log(e)
        res.status(502).send({message:'mail got stuck in ', e })
    }
})


/**reset token in password recovery */
router.get('/', async(req: Request, res: Response):Promise<Response|void>=>{
    const token = req.query.token;
    if(!token) return res.status(401).send({Message:'token not exists'})
    const passwordRecovery = await dataSource
    .createQueryBuilder()
    .from(PasswordRecovery,'passwordRecovery')
    .select('passwordRecovery')
    .innerJoinAndSelect('passwordRecovery.user', 'user')
    .where(' passwordRecovery.token=:token',{token})
    .getOne()
    if(!passwordRecovery || !passwordRecovery.enabled) return res.status(404).send({message:"Token is not valid"})
    res.send(passwordRecovery)
    passwordRecovery.enabled=false;
    try{
        await passwordRecovery.save();
    } catch(e){
    console.log(e)
}
})


/**change password */
router.patch('/:id/change-password', async (req: Request, res: Response):Promise<Response|void>=>{
    const user = await dataSource
    .getRepository(User)
    .findOneBy({id:req.params.id})
    if(!user) return res.status(404).send({Message:'user not found'})
    const salt = await bcrypt.genSalt(SALT_WORK_FACTOR);
    const newPassword:string = await bcrypt.hash(req.body.password, salt);
    user.password = newPassword
    try{
        await user.save()
        res.send({message:"Password saved"})
    } catch (e){
        res.status(502).send({message:"error in saving new psasword"})
    }
})


 
    export default router;