import {useNavigate} from "react-router-dom";
import {useDispatch, useSelector} from "react-redux";
import {Typography} from "@mui/material";
import { useEffect } from "react";
import ProjectForm from "../../components/ProjectForm/ProjectForm";
import { createProject, fetchProjects } from "../../store/actions/projectsActions";

const NewProject = () => {
    const dispatch = useDispatch();
    const projects = useSelector(state => state.projects.projects);
    const navigate = useNavigate();
    const onSubmit = async (projectData) => {
        await dispatch(createProject(projectData, navigate));
    };

    useEffect(()=> {
        dispatch(fetchProjects());
    }, [dispatch])

    return (
        <>
            <Typography variant="h2">New project</Typography>
            <ProjectForm projects={projects} onSubmit={onSubmit} />
        </>
    );
};

export default NewProject;