import * as React from "react";
import TableCell from "@mui/material/TableCell";
import Input from "@mui/material/Input";

const CustomTableCell = ({task,
  name,
  value,
  onChange,
  onModalOpen,
  placeholder,
 }) => {
  const styles = { width: "auto", height: "10px"};

  if (task) {
    return (
      <>
        <TableCell
          onClick={(e) => (onModalOpen ? onModalOpen(e, task) : null)}
          align="left"
          style={styles}
        >
          {task.isEditMode && onChange ? (
            <Input
              placeholder={placeholder}
              value={value}
              name={name}
              onChange={(e) => onChange(e, task)}
              style={styles}
            />
          ) : (
            <span>{value}</span>
          )}
        </TableCell>
      </>
    );
  }
};

export default CustomTableCell;
