import { Button, Grid} from "@mui/material";
import React, { memo, useEffect, useRef, useState} from "react";
import ArrowBackIcon from '@mui/icons-material/ArrowBack';
import ArrowForwardIcon from '@mui/icons-material/ArrowForward';

const arrowClass = {
  height: '20px',
  cursor: 'pointer',
  transition: '0.5s',
  "&:hover": { 
  transition: '0.5s',
  transform: 'scale(1.2)'
  }
}

const CalendarTask = ({setCurrentTask, handleOpen, task, line, setCurrentLine, increaseTaskHandler, reduceTaskHandler,  hourFormat, setCopyTask}) => {

  const [color, setColor] = useState('')
  useEffect(() => {
    if (task.priority) {
      if (task.priority === 'A') setColor('rgb(32, 138, 250)')
      if (task.priority === 'B') setColor('lightgreen')
      if (task.priority === 'C') setColor('yellow')
    } else {
      setColor('rgb(171, 157, 157);')
    }
  }, [task])

  const onClickTaskHandler = (e, task) => {
    e.stopPropagation(); 
    setCurrentTask(task); 
    handleOpen(e)
  }
  
  const dragLeaveHandler = (e) => {
    e.target.style.boxShadow = 'none'
  }
  const dragStartHandler = (e, line, task) => {
    setCurrentLine()
    setCurrentTask(task); 
  }
  const dragEndHandler = (e) => {
    e.target.style.boxShadow = 'none'
  }
  
  return (<>
    <Grid  
        draggable={true} 
        onDragLeave={(e)=>{dragLeaveHandler(e)}}
        onDragStart={(e)=>{dragStartHandler(e, line, task)}}
        onDragEnd={(e)=>{dragEndHandler(e)}}
        sx={{ position: 'relative', height: '30px', backgroundColor: color, whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis', borderRadius: '10px', margin: '5px 10px', display: 'flex', justifyContent: 'flex-start', alignItems: 'center', paddingLeft: '5px', zIndex: '5', justifyContent: 'space-between'}} 
        onClick={(e)=>{onClickTaskHandler(e, task)}}
      >
      {task.infoForCell.endHour === task.infoForCell.startHour && hourFormat ?  
      <>
        <div tyle={{display: 'flex', alignItems: 'center'}}>
            <div style={{display: 'flex', alignItems: 'center'}}>
              <ArrowBackIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); increaseTaskHandler(line, task, true)}}/>
              <ArrowForwardIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); reduceTaskHandler(line, task, true)}}/>
              <ArrowBackIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); reduceTaskHandler(line, task, false)}}/>
              <ArrowForwardIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); increaseTaskHandler(line, task, false)}}/>
            </div>
        </div>
        <div>
          <span>
          {task.title}
         </span>
        </div>
      </>
      
      
      :
        <>
          <div style={{display: 'flex', alignItems: 'center'}}>
            <ArrowBackIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); increaseTaskHandler(line, task, true)}}/>
            <ArrowForwardIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); reduceTaskHandler(line, task, true)}}/>
            </div>
              <span>
                {task.title}
              </span>
            <div style={{display: 'flex', alignItems: 'center'}}>
            <Button sx={{color:'black', fontWeight:'600'}} onClick={(e)=>{e.stopPropagation(); setCopyTask(task)}}>
                Copy
            </Button>
            <ArrowBackIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); reduceTaskHandler(line, task, false)}}/>
            <ArrowForwardIcon sx={arrowClass} onClick={(e)=>{e.stopPropagation(); increaseTaskHandler(line, task, false)}}/>
          </div>
        </>
        }
    </Grid>
  </>)
};

export default memo(CalendarTask);