import { Grid } from "@mui/material";
import { memo, useEffect, useMemo, useState } from "react";
import CalendarStandartCell from "../CalendarStandartCell.js/CalendarStandartCell";
import CalendarTask from "../CalendarTask/CalendarTask";
import EmptyBox from "./EmptyBox/EmptyBox";
import { getAvailableTasks, getBoxesInLine, getLinesInDay, getSortedTasks } from "./Helpers";

const CalendarRowDay = ({xs, hoursInDay, createTaskInCellHandler, currentTask, handleOpen, modal, setCurrentTask, year, month, tasks, day, hourFormat, setCurrentLine, currentLine, dragTaskHandler, increaseTaskHandler, reduceTaskHandler, createCopyTask, setCopyTask, copyTask}) => {

  const hours = useMemo(()=>{ 
    return hoursInDay.map((hour)=>parseInt(hour.split(':')[0]))},
  [hoursInDay])

  const availableTasks = useMemo(() => {
    return getAvailableTasks(tasks, year, month, day.dayNumber)
  }, [tasks, month, year, day.dayNumber])

  const sortedTasks = useMemo(() => {
    return getSortedTasks(availableTasks)
  }, [availableTasks])

  const linesInDay = useMemo(() => {
    return getLinesInDay(availableTasks, sortedTasks, hoursInDay, hours, hourFormat)
  }, [availableTasks, hourFormat, hours, hoursInDay, sortedTasks])

  return <>
      <Grid 
        container
        item
        xs={10.8}
        align='center'
        sx={{position: 'relative'}}
        >
          {hoursInDay.map((hour, i)=>{
            return (
              <CalendarStandartCell
                  linesInDay={linesInDay}
                  key={i} 
                  item xs={xs}
                  createTaskInCellHandler={createTaskInCellHandler}
                  hours={hour}
                  dragTaskHandler={dragTaskHandler}
                  dayNumber={day.dayNumber}
                  currentTask={currentTask}
                  handleOpen={handleOpen}
                  modal={modal}
                >
              </CalendarStandartCell>
              ) 
            })}
            <Grid sx={{position: 'absolute', top: '0'}} container item xs={12}>
            {linesInDay?.map((line, i)=>{
              const boxes = getBoxesInLine(line, hoursInDay, sortedTasks)
              return(
              <Grid key={i} container sx={{height: '35px', backgroundColor: 'rgb(0,0,0,0)', marginBottom: '5px'}}>
                {boxes.map((box, index)=>{
                  if (box.task) {
                    return (<Grid 
                        item xs={box.xs} 
                        key={box.task.id}
                        sx={{height: '35px', marginBottom: '5px'}}
                        >
                      <CalendarTask
                       dragTaskHandler={dragTaskHandler}
                       setCurrentLine={()=>{setCurrentLine(day.dayNumber)}} 
                       currentTask={currentTask}
                       currentLine={currentLine}
                       hour={parseInt(hours[index])}
                       line={day.dayNumber}
                       task={box.task}
                       hourFormat={hourFormat}
                       setCurrentTask={setCurrentTask} 
                       handleOpen={handleOpen}
                       increaseTaskHandler={increaseTaskHandler} 
                       reduceTaskHandler={reduceTaskHandler}
                       setCopyTask={setCopyTask}
                       />
                    </Grid>)
                  } else {
                    return (<EmptyBox 
                      key={index}
                      modal={modal}
                      dayNumber={day.dayNumber}
                      hourNumber={box.hour}
                      handleOpen={handleOpen}
                      dragTaskHandler={dragTaskHandler}
                      createCopyTask={createCopyTask}
                      copyTask={copyTask}
                      createTaskInCellHandler={createTaskInCellHandler}
                      xs={box.xs}
                      >
                      </EmptyBox>)
                  }
                })}
              </Grid>)
            })}
            </Grid>

            <Grid container sx={{height: '35px', backgroundColor: 'rgb(0,0,0,0)', marginBottom: '5px', position: 'absolute', bottom: '0'}}>
              {hoursInDay.map((hour, i)=>{
                const hourNumber = parseInt(hour)
                return(<EmptyBox 
                  key={i}
                  modal={modal}
                  dayNumber={day.dayNumber}
                  hourNumber={hourNumber}
                  handleOpen={handleOpen}
                  dragTaskHandler={dragTaskHandler}
                  createCopyTask={createCopyTask}
                  copyTask={copyTask}
                  createTaskInCellHandler={createTaskInCellHandler}
                  xs={xs}
                  >
                  </EmptyBox>)
              })}
            </Grid>
        </Grid>
    </>
};

export default memo(CalendarRowDay, (prevProps, nextProps)=>{
  if(!prevProps.modal) return false
  if(nextProps.modal) return true
});

