import {DELETE_MEMBER_FAILURE, DELETE_MEMBER_REQUEST, DELETE_MEMBER_SUCCESS, FETCH_PROJECTS_ERROR, FETCH_PROJECTS_REQUEST, FETCH_PROJECTS_SUCCESS, FETCH_PROJECT_SUCCESS } from "../actionTypes/projectsActionTypes";

const initialState = {
    projects: [],
    project: "",
    loading: false, 
    error: null
  };
  
  const projectsReducer = (state = initialState, action) => {
    switch (action.type) {
      case FETCH_PROJECTS_REQUEST:
        return {...state, loading: true};
      case FETCH_PROJECTS_SUCCESS:
        return {...state, loading: false, projects: action.projects};
      case FETCH_PROJECTS_ERROR:
        return {...state, loading: false, error: action.error};
      case FETCH_PROJECT_SUCCESS:
          return {...state, loading: false, project: action.project}
      case DELETE_MEMBER_SUCCESS:
          return {...state, loading: false};
      case DELETE_MEMBER_REQUEST:
          return {...state, loading: true};
      case DELETE_MEMBER_FAILURE:
          return {...state, loading: false, error: action.error};
      default:
        return state;
    }
  };
  
  export default projectsReducer;