import axios from "../../axiosPlanner";
import { FETCH_USERS_FAILURE, FETCH_USERS_REQUEST, FETCH_USERS_SUCCESS, LOGIN_USER_FAILURE, LOGIN_USER_SUCCESS, LOGOUT_USER_FAILURE, LOGOUT_USER_SUCCESS, REGISTER_USER_FAILURE, REGISTER_USER_REQUEST, REGISTER_USER_SUCCESS,FETCH_USERS_ALL_FIELDS_REQUEST,
    FETCH_USERS_ALL_FIELDS_SUCCESS,
    FETCH_USERS_ALL_FIELDS_FAILURE, } from "../actionTypes/userActionTypes"
import { showNotification } from "./commonActions";

const registerUserRequest = () => {
    return {type: REGISTER_USER_REQUEST}
};

const registerUserSuccess = () => {
    return {type: REGISTER_USER_SUCCESS}
};

const registerUserFailure = (error) => {
    return {type: REGISTER_USER_FAILURE, error}
};

const fetchUsersRequest = () => {
    return {type: FETCH_USERS_REQUEST}
};
const fetchUsersSuccess = (users) => {
    return {type: FETCH_USERS_SUCCESS, users}
};
const fetchUsersFailure = () => {
    return {type: FETCH_USERS_FAILURE}
};

const fetchUsersAllFieldsRequest = () => {
    return {type: FETCH_USERS_ALL_FIELDS_REQUEST}
};
const fetchUsersAllFieldsSuccess = (users) => {
    return {type: FETCH_USERS_ALL_FIELDS_SUCCESS, users}
};
const fetchUsersAllFieldsFailure = () => {
    return {type: FETCH_USERS_ALL_FIELDS_FAILURE}
};

export const registerUser = (userData, navigate) => {
    return async (dispatch) => {
        dispatch(registerUserRequest());
        try {
            const response = await axios.post("/users", userData);
            dispatch(registerUserSuccess())
            navigate("/")
        } catch (error) {
            if (error.response?.data) {
                dispatch(registerUserFailure(error.response.data));
            } else {
                dispatch(registerUserFailure({global: "Потеряно соедиение"}));
            }
        }
    }
}

const loginUserSuccess = (user) => {
    return {type: LOGIN_USER_SUCCESS, user}
}

const loginUserFailure = (error) => {
    return {type: LOGIN_USER_FAILURE, error}
}
const logoutUserSuccess = () => {
    return {type: LOGOUT_USER_SUCCESS}
}

const logoutUserFailure = (error) => {
    return {type: LOGOUT_USER_FAILURE, error}
}

export const loginUser = (userData, navigate) => {
    return async (dispatch) => {
        try {
            const response = await axios.post("users/sessions", userData);
            dispatch(loginUserSuccess(response.data.user));
            navigate("/")
        } catch (e) {
            dispatch(loginUserFailure(e?.response?.data?.err))
        }
    }
}

export const forgottenPassword = (userData, navigate) => {
    return async (dispatch) => {
        try {
            console.log( 'forgottenPassword userData ',userData)
            const response = await axios.post("users/requestPasswordReset", userData);
            // if (userData.email === response.data.email) {

            // }
            dispatch(loginUserSuccess(response.data));
            navigate("/")
        } catch (e) {
            dispatch(loginUserFailure(e?.response?.data?.err))
        }
    }
}

export const logoutUser = (navigate) => {
    return async (dispatch) => {
        try {
            await axios.delete("/users/sessions");
            dispatch(logoutUserSuccess());
            navigate("/");
            dispatch(showNotification("Вы успешно вышли"));
        } catch (e) {
            dispatch(logoutUserFailure(e?.response?.data));
            dispatch(showNotification("Не удалось выйти", "error"));
        }
    } 
}

export const fetchUsers = () => {
    return async dispatch => {
        dispatch(fetchUsersRequest());
        try {
            const response = await axios.get("/users");
            dispatch(fetchUsersSuccess(response.data.users));
            console.log(response.data.users)
        } catch (e) {
            dispatch(fetchUsersFailure(e));
        }
    }
};


export const fetchUsersAllFields = () => {
    return async dispatch => {
        dispatch(fetchUsersAllFieldsRequest());
        try {
            const response = await axios.get("/users/all-fields/");
            dispatch(fetchUsersAllFieldsSuccess(response.data.users));
        } catch (e) {
            dispatch(fetchUsersAllFieldsFailure(e));
        }
    }
};

