import { AppBar, Box, Toolbar, Typography } from "@mui/material";
import { NavLink } from "react-router-dom";
import { useSelector } from "react-redux";
import HasAccess from "../HasAccess/HasAccess";
import AnonymousMenu from "../../Menus/AnonymousMenu/AnonymousMenu";
import WorkerMenu from "../../Menus/WorkerMenu/WorkerMenu";
import AdminMenu from "../../Menus/AdminMenu/AdminMenu";

const AppToolbar = () => {
    const user = useSelector(state => state.users.user);

    return <Box sx={{ flexGrow: 1, mb: "40px" }}>
        <AppBar position="static">
            <Toolbar>
                <Typography
                    variant="h4"
                    component="div"
                    sx={{ flexGrow: 1 }}>

                    <NavLink to='/' style={{ textDecoration: 'none', color: 'inherit' }}>Task Manager</NavLink>
                </Typography>

                <HasAccess allowed={!user}>
                    <AnonymousMenu />
                </HasAccess>
                <HasAccess roles={['user']}>
                    <WorkerMenu />
                </HasAccess>
                <HasAccess roles={['superuser']}>
                    <AdminMenu />
                </HasAccess>
            </Toolbar>
        </AppBar>
    </Box>
};

export default AppToolbar;
