import { Grid } from "@mui/material";
import React, { memo, useEffect, useState } from "react";
import ContentCopyIcon from '@mui/icons-material/ContentCopy';

const CalendarTask = ({ setCurrentTask, handleOpen, task, line, setCurrentLine, setCopyTask }) => {

  const [color, setColor] = useState('')
  useEffect(() => {
    if (task.priority) {
      if (task.priority === 'A') setColor('rgb(32, 138, 250)')
      if (task.priority === 'B') setColor('lightgreen')
      if (task.priority === 'C') setColor('yellow')
    } else {
      setColor('rgb(171, 157, 157);')
    }
  }, [task])

  const onClickTaskHandler = (e, task) => {
    e.stopPropagation();
    setCurrentTask((prevState) => {
      return {
        ...task,
        infoForCell: {
          ...task.infoForCell,
          endHour: task.infoForCell.endHour + 1
        }
      }
    });
    handleOpen(e)
  }

  const dragLeaveHandler = (e) => {
    e.target.style.boxShadow = 'none'
  }
  const dragStartHandler = (e, line, task) => {
    setCurrentLine()
    setCurrentTask(task);
  }
  const dragEndHandler = (e) => {
    e.target.style.boxShadow = 'none'
  }

  return (<>
    <Grid
      draggable={true}
      onDragLeave={(e) => { dragLeaveHandler(e) }}
      onDragStart={(e) => { dragStartHandler(e, line, task) }}
      onDragEnd={(e) => { dragEndHandler(e) }}
      sx={{ position: 'relative', height: '30px', backgroundColor: color, borderRadius: '10px', margin: '5px 10px', display: 'flex', alignItems: 'center', zIndex: '5', justifyContent: 'space-between', padding: '0 15px' }}
      onClick={(e) => { onClickTaskHandler(e, task) }}
    >
      <span style={{ maxWidth: '60%', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis' }}>
        {task.title}
      </span>
      <ContentCopyIcon sx={{ width: '20px', cursor: 'pointer' }} onClick={(e) => { e.stopPropagation(); setCopyTask(task) }}>
      </ContentCopyIcon>


    </Grid>
  </>)
};

export default memo(CalendarTask);