import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    BaseEntity,
    OneToOne,
    CreateDateColumn,
    JoinColumn,
  } from 'typeorm';
import { User } from './User';
  
  interface IPasswordRecovery{
    createdAt:Date;
    token: string;
    user: User;
    enabled:boolean;
  }

  @Entity({name: 'PasswordRecovery'})
  export class PasswordRecovery extends BaseEntity implements IPasswordRecovery{
    @PrimaryGeneratedColumn('uuid')
    id!: string;

    @CreateDateColumn({ name: 'created_at', type: Date, default: new Date() })
    createdAt!: Date;

    @Column({ name: 'token', type: 'varchar',length:100, unique: true, nullable:true })
    token!: string;  

    @OneToOne(()=>User,{nullable: false, eager:true, onDelete:"CASCADE"})
    @JoinColumn()
    user!:User;

    @Column({ name: 'enabled', type:'boolean', default:true})
    enabled!: boolean;

  }