import * as React from 'react';
import TextField from '@mui/material/TextField';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import { DateTimePicker } from '@mui/x-date-pickers/DateTimePicker';
import { useState, useEffect } from "react";
import dayjs from 'dayjs';
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";

export default function MaterialUIPickers(props) {
 
console.log(props)
 
if (props.task.dateTimeStart!==undefined)
  return (
    <LocalizationProvider dateAdapter={AdapterMoment}>
    <DateTimePicker
      renderInput={(params) => (
        <TextField {...params} name="dateCreated" />
      )}
      value={
        props.newStartedDate && props.newStartedDate.id === props.task.id? props.newStartedDate.date
          : props.task.dateTimeStart
      }
      onChange={(newValue) => {
        props.setNewStartedDate({
          id: props.task.id,
          date: newValue,
        });
      }}
    />
  </LocalizationProvider>
  );

else if(props.task.dateTimeDue!==undefined) {
  return (
    <LocalizationProvider dateAdapter={AdapterMoment}>
    <DateTimePicker
      renderInput={(params) => (
        <TextField {...params} name="dateCreated" />
      )}
      value={
        props.newDueDate && props.newDueDate.id === props.task.id? props.newDueDate.date
          : props.task.dateTimeDue
      }
      onChange={(newValue) => {
        props.setNewDueDate({
          id: props.task.id,
          date: newValue,
        });
      }}
    />
  </LocalizationProvider>
  );
}
}