import { Grid, TextField } from "@mui/material";
import { useEffect, useState } from "react";

const exampleTasks=[
  {
    user:"first",
    title:"задача1",
    description:"описание задачи11111",
    priority:"A",
    author:"Ivan",
    executor:"Arman",
    dateTimeStart:"26.12.2022 20:00:00",
    dateTimeDue:"27.10.2022 14:20:00",
    id:1,
    dateCreated:"26.10.2022"
  }, {
    user:"first",
    title:"задача2",
    description:"описание задачи11111",
    priority:"A",
    author:"Ivan",
    executor:"Arman",
    dateTimeStart:"1.12.2022 9:00:00",
    dateTimeDue:"27.10.2022 15:20:00",
    id:1,
    dateCreated:"26.10.2022"
  },{
    user:"first",
    title:"first",
    description:"описание задачи11111",
    priority:"A",
    author:"Ivan",
    executor:"Arman",
    dateTimeStart:"5.11.2022 16:00:00",
    dateTimeDue:"5.11.2022 17:00:00",
    id:1,
    dateCreated:"26.10.2022"
  },{
    user:"first",
    title:"second",
    description:"описание задачи11111",
    priority:"A",
    author:"Ivan",
    executor:"Arman",
    dateTimeStart:"5.11.2022 16:00:00",
    dateTimeDue:"5.11.2022 17:00:00",
    id:1,
    dateCreated:"26.10.2022"
  }
]


function MonthCalendarBody({month, year}) {
  
  const [hoursInDay, setHoursInDay] = useState(['8:00', '10:00', '12:00', '14:00', '16:00', '18:00', '20:00', '22:00', '6:00'])
  const [daysInMonth, setDaysInMonth] = useState([])
  const [tasksForCell, setTasksForCell] = useState([])

  useEffect(()=>{
    setNewMonthDays(month, year)
    setNewTasksWithInfoForCell(exampleTasks, month, year)
  }, [month, year])

  const getDaysInMonth = () => { 
    return new Date(year, month + 1, 0).getDate();
  }

   const getDayOfWeekString = (day) => {
    return ["ВС","ПН","ВТ","СР","ЧТ","ПТ","СБ"][day];
  }

  const getDayOfWeekNumber = (month, year, day) => {
    return new Date(year, month, day).getDay()
  }

  const setNewTasksWithInfoForCell = (tasks, month, year) => {
    const newArr = tasks.map((task)=>{
      const dateStart = task.dateTimeStart.split(' ')[0]
      const timeStart = task.dateTimeStart.split(' ')[1]
      const timeEnd = task.dateTimeDue.split(' ')[1]
      const dayStart = parseInt(dateStart.split('.')[0])
      const dayOfWeekStartNumber = getDayOfWeekNumber(month, year, dayStart)
      const dayOfWeekStartString = getDayOfWeekString(dayOfWeekStartNumber)
      const monthStartNumber =  parseInt(dateStart.split('.')[1])
      const yearStartNumber =  parseInt(dateStart.split('.')[2])
      const timeStartHour = parseInt(timeStart.split(':')[0])
      const timeEndHour = parseInt(timeEnd.split(':')[0])
      return {...task, 
        startDay: dayStart, 
        startDayOfWeek: dayOfWeekStartString, 
        startHour: timeStartHour, 
        startMonth: monthStartNumber,
        startYear: yearStartNumber,
        endHour: timeEndHour,
      } 
    })
    setTasksForCell(newArr)
  }

  const createTaskInCellHandler = (month, year, dayOfWeek, dayNumber, dayHour) => {
    const newTasks = [...tasksForCell]
    const newTask = {
      id: Date.now(),
      user:"first",
      title:"Новая",
      description:"описание задачи11111",
      priority:"A",
      author:"Ivan",
      executor:"Arman",
      dateTimeStart:`${dayNumber}.${month+1}.${year} ${parseInt(dayHour.split(':')[0])}:00:00`,
      dateTimeDue:`${dayNumber}.${month+1}.${year} ${parseInt(dayHour.split(':')[0]) + 1}:00:00`,
    }
    newTasks.push(newTask)
    exampleTasks.push(newTask)
    setNewTasksWithInfoForCell(newTasks, month, year)
  }

  const getTaskInDayCell = (tasks, day, hours, month, year) => {
    const task = tasks.find(task=> {
    if (year === task.startYear) {
      if (month + 1 === task.startMonth) {
        if (day.dayNumber === task.startDay && task.startDayOfWeek === day.dayOfWeek ) {
          if ((task.endHour <= parseInt(hours.split(':')[0]) || task.startHour <= parseInt(hours.split(':')[0])) && (task.endHour >= parseInt(hours.split(':')[0]))) {
            return task
          }
        }
      }      
    }
    })
    return task
  }
  

  const setNewMonthDays = (month, year) => {
    const newDaysInMonth = []
    for (let i = 1; i <= getDaysInMonth(month, year); i++) {
      const dayOfWeekNumber = getDayOfWeekNumber(month, year, i)
      newDaysInMonth.push({dayNumber: i, dayOfWeek: getDayOfWeekString(dayOfWeekNumber)})
    }
    setDaysInMonth(newDaysInMonth)
  }
  
  const onChangeCellTaskTitle = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = tasksForCell.map(task => {
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });
    setTasksForCell(newTasks);
    exampleTasks = [...newTasks]
  }

  return (
    <>
    <Grid
      container
      align='center'
      sx={{borderBottom: '1px solid black', borderRight: '1px solid black', borderLeft: '1px solid black'}}
      >
        <Grid align='center' item xs={0.5} sx={{borderRight: '1px solid black'}}>
          {' '}
        </Grid>
        <Grid align='center' item xs={0.5} sx={{borderRight: '1px solid black'}}>
          {' '}
        </Grid>
        {hoursInDay.map((hours, i)=>{
          return (
            <Grid key={i} item xs={1.2222} sx={{borderRight: '1px solid black'}}>
              {hours}
            </Grid>
            ) 
          })}
    </Grid>
    {daysInMonth.map((day, i)=>{
      return (
        <Grid 
          key={i}
          container 
          align='center'
          sx={{borderBottom: '1px solid black', borderRight: '1px solid black', borderLeft: '1px solid black'}}
          >
            <Grid align='center' item xs={0.5} sx={{borderRight: '1px solid black'}}>
              {day.dayNumber}
            </Grid>
            <Grid align='center' item xs={0.5} sx={{borderRight: '1px solid black'}}>
              {day.dayOfWeek}
            </Grid>
            {hoursInDay.map((hours, i)=>{
              const task = getTaskInDayCell(tasksForCell, day, hours, month, year)
              return (
                <Grid  
                  key={i} 
                  item xs={1.2222} 
                  sx={{borderRight: '1px solid black'}} 
                  onClick={()=>{createTaskInCellHandler(month, year, day.dayOfWeek, day.dayNumber, hours)}}>
                  { task ? 
                    <Grid  key={i} sx={{backgroundColor: 'lightgreen'}}>
                        <TextField 
                        id={task.title} 
                        variant="standard" 
                        value={task.title} 
                        name='title' 
                        onChange={(e)=>{onChangeCellTaskTitle(e, task)}}></TextField>
                    </Grid> : null}
                </Grid>
                ) 
              })}
        </Grid>
      )
    })}
    </>
  );
}

export default MonthCalendarBody;