import express,{Router, Request, Response} from 'express';
import {Project} from '../models/Project';
import {myDataSource} from '../app-data-source';
import { User } from '../models/User';

const router:Router = express.Router();
const dataSource = myDataSource;


router.get('/',async (req:Request, res:Response): Promise<Response>=> {
    const projects:Project[] = await dataSource.manager.find(Project)
    return res.send({projects})
})


router.post('/', async (req:Request, res:Response): Promise<Response> => {
    if (!req.body) return res.status(400).send({Message:'problem in incoming req.body'})
    const token = req.get('Authorization');
    const {title, dateDue,color,department,workers,tasks}= req.body;
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne()
    if(!user) return res.status(404).send({Message:'user not found'})
    const project : Project= new Project()
    project.title = title;
    project.color = color; 
    project.dateDue = dateDue || null;
    project.department = department;
    project.workers = workers|| null;
    project.tasks = tasks || null;
    project.admin = user;
    await project.save()
    return res.send({project})
})

router.get("/id/:id",async (req:Request, res:Response): Promise<Response> => {
    const project = await dataSource
    .createQueryBuilder()
    .select("project")
    .from(Project, "project")
    .leftJoinAndSelect('project.admin', 'user')
    .where("project.id = :id", { id: req.params.id })
    .getOne()
    if (!project) return res.status(404).send({Message:'no info on this project'})
    return res.send({project})
})

router.get('/userId/:userId', async (req : Request, res : Response): Promise<Response>=>{
    const userId:string = req.params.userId
    const userProjects = await dataSource
    .createQueryBuilder()
    .select('project')
    .from(Project, "project")
    .where("project.admin = :id", { id: userId })
    .getMany();
    return res.send({userProjects})
})

export default router;
