import {Table, TableContainer, } from "@mui/material";
import { memo } from "react";
import NewTaskForm from "./NewTaskForm/NewTaskForm";
import UsersTasksTableBody from "./UsersTasksTableBody/UsersTasksTableBody";
import UsersTasksTableHead from "./UsersTasksTableHead/UsersTasksTableHead";


function UsersTasksTableContainer({ order, orderBy, handleRequestSort, rows, page, rowsPerPage, addFormStatus, onChangeNewTaskHandler, newTask, allUserProjectsForModalTask, onDateChangeHandler, createNewTaskHandler, deleteTaskHandler, calendarOpen, deleteCopyTaskHandler, currentTask, setCurrentTask, onChangeCurrentTaskHandler, onDateChangeEditHandler, editCurrentTaskHandler}) {
  return (
    <TableContainer>
      <NewTaskForm
        addFormStatus={addFormStatus}
        onChangeNewTaskHandler={(e)=>{onChangeNewTaskHandler(e)}}
        newTask={newTask}
        allUserProjectsForModalTask={allUserProjectsForModalTask}
        onDateChangeHandler={onDateChangeHandler}
        createNewTaskHandler={()=>{createNewTaskHandler()}}
      />
      <Table
        sx={{ minWidth: 750 }}
        aria-labelledby="tableTitle"
      >
        <UsersTasksTableHead
          order={order}
          orderBy={orderBy}
          handleRequestSort={handleRequestSort}
          deleteTaskHandler={deleteTaskHandler}
        />
        <UsersTasksTableBody
          order={order}
          orderBy={orderBy}
          rows={rows}
          page={page}
          rowsPerPage={rowsPerPage}
          deleteTaskHandler={deleteTaskHandler}
          calendarOpen={calendarOpen}
          deleteCopyTaskHandler={deleteCopyTaskHandler}
          currentTask={currentTask}
          setCurrentTask={setCurrentTask}
          onChangeCurrentTaskHandler={onChangeCurrentTaskHandler}
          allUserProjectsForModalTask={allUserProjectsForModalTask}
          onDateChangeEditHandler={onDateChangeEditHandler}
          editCurrentTaskHandler={editCurrentTaskHandler}
        />
      </Table>
    </TableContainer>
  );
}

export default memo(UsersTasksTableContainer)