import * as React from 'react';
import { useTheme } from '@mui/material/styles';
import OutlinedInput from '@mui/material/OutlinedInput';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import FormControl from '@mui/material/FormControl';
import Select from '@mui/material/Select';

const ITEM_HEIGHT = 48;
const ITEM_PADDING_TOP = 8;
const MenuProps = {
  PaperProps: {
    style: {
      maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
      width: 200,
      color:'#1976d2',
      borderColor:'white'
    },
  },
};

function getStyles(name, personName, theme) {
  return {
    fontWeight:
      personName.indexOf(name) === -1
        ? theme.typography.fontWeightRegular
        : theme.typography.fontWeightMedium,
  };
}

export default function MultipleSelect({projects,onCloseFilterByProjects}) {
  const theme = useTheme();
  const [listProjectIds, setListProjectIds ] = React.useState([])
  const handleChange = (event) => {
    const {
      target: { value },
    } = event;
    setListProjectIds(
      // On autofill we get a stringified value.
      typeof value === 'string' ? value.split(',') : value,
    );
  };

  return (
    <div>
      <FormControl sx={{ m: 1, width: 250,borderColor:'white' }}>
        <InputLabel placeholder='Choose Project' 
        label='I am a really really long green TextField label' 
        id="demo-multiple-name-label" sx={{color:'white', padding:'1' }}
        >Проекты</InputLabel>
        <Select
          labelId="demo-multiple-name-label"
          label='Выберите проект'
          name='Choose Project'
          id="demo-multiple-name"
          multiple
          value={listProjectIds}
          onChange={handleChange}
          input={<OutlinedInput label="Name" />}
          MenuProps={MenuProps}
          sx={{color:'white' }}
          onClose={(e)=>{onCloseFilterByProjects(listProjectIds)}}
        >
          {projects?.map((project,index) => (
            <MenuItem
              key={index}
              value={project.id}
              style={getStyles(project.title, listProjectIds, theme)}
            >
              {project.title}
            </MenuItem>
          ))}
        </Select>
      </FormControl>
    </div>
  );
}