import React from 'react';
import Box from '@mui/material/Box';
import Modal from '@mui/material/Modal';
import { useDispatch, useSelector } from "react-redux";
import { logoutUser, loginUser } from '../../store/actions/usersActions';
import SwitchUserForm from './SwitchUserForm/SwitchUserForm';
import { useNavigate } from "react-router-dom";


const style = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: 'fit-content',
  bgcolor: 'background.paper',
  border: '2px solid #000',
  boxShadow: 24,
  p: 4,
};

const SwitchUserModal= ({open, handleClose})=> {
    const dispatch= useDispatch();
    const usersAllFields = useSelector(state => state.users.usersAllFields)
    const navigate= useNavigate();
    const submitFormHandler=(e, currentUser)=>{
      dispatch(logoutUser(navigate))
      e.preventDefault();
      e.preventDefault();
        dispatch(loginUser({
            "email": currentUser.email,
            "password": "123"
        }, navigate))
    }

  return (
    <div>
      <Modal
        open={open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
      >
        <Box sx={style}>
    
        <SwitchUserForm
        
        submitFormHandler = {submitFormHandler}
        users = {usersAllFields}
        />
          </Box>
      </Modal>

     
    </div>
  );
}
export default SwitchUserModal;
