import {Button} from '@mui/material';
import {Add, Close} from "@mui/icons-material";
import { memo } from 'react';

function CreateTaskFromButton({ addFormStatus, onClick }) {
  return (
    <Button
      color={addFormStatus === true ? "info" : "inherit"}
      style={{
        backgroundColor: addFormStatus === true ? "white" : "inherit",
        width: '280px'
      }}
      onClick={onClick}
    >
      {addFormStatus === true ? (
        <>
          <Close />
          <span style={{ lineHeight: "16px" }}>Скрыть задачу</span>
        </>
      ) : (
        <>
          <Add />
          <span style={{ lineHeight: "16px" }}>Добавить задачу</span>
        </>
      )}
    </Button>
  );
}

export default memo(CreateTaskFromButton)