import { Collapse, IconButton, Table, TableBody, TableCell, TableHead, TableRow, Tooltip, Typography } from "@mui/material";
import RemoveIcon from '@mui/icons-material/Remove';
import moment from "moment";
import { memo } from "react";
import { Box } from "@mui/system";

const weekDays = ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"];

function TableForCopiesTasks({ task, openCopies, user, deleteCopyTaskHandler }) {
  const roudHourUp = (dateIso) => {
    let m = moment(dateIso);
    let roundUp = m.minute() || m.second() || m.millisecond() ? m.add(1, 'hour').startOf('hour') : m.startOf('hour');
    return roundUp
  }

  const timeTransform = (dateIso) => {
    const exp = roudHourUp(moment.utc(dateIso)).format("HH:00")
    return exp;
  }

  const getDayOfWeek = (dateIso) => {
    const date = moment.utc(dateIso);
    return weekDays[date.day()];
  }

  return (
    <TableRow>
      <TableCell style={{ paddingBottom: 0, paddingTop: 0 }} colSpan={11}>
        <Collapse in={openCopies} timeout="auto" unmountOnExit>
          <Box sx={{ margin: 1 }}>
            <Typography variant="h6" gutterBottom component="div">
              Расписание
            </Typography>
            <Table size="small" aria-label="purchases" sx={{
              backgroundColor: "#ebebeb"
            }}>
              <TableHead>
                <TableRow>
                  <TableCell colSpan={10} >Дата создания</TableCell>
                  <TableCell align="right">День недели</TableCell>
                  <TableCell align="right">Начало</TableCell>
                  <TableCell align="center" colSpan={1}>Окончание</TableCell>
                  <TableCell align="center" ></TableCell>
                  <TableCell align="center" ></TableCell>
                </TableRow>
              </TableHead>
              <TableBody>
                {task.dateTimeTasks.map((dateTimeTask, index) => (
                  <TableRow key={index}>
                    <TableCell component="th" scope="row" colSpan={10}>
                      {moment(task.createdAt)
                        .utc()
                        .format("DD/MM")}
                    </TableCell>
                    <TableCell align="right">
                      {getDayOfWeek(dateTimeTask.dateTimeStart)}, {moment(dateTimeTask.dateTimeStart)
                        .utc()
                        .format("DD/MM")}
                    </TableCell>
                    <TableCell align="right">
                      {timeTransform(dateTimeTask.dateTimeStart)}
                    </TableCell>
                    <TableCell align="center" colSpan={1}>
                      {timeTransform(dateTimeTask.dateTimeDue)}
                    </TableCell>

                    {task.author.id === user.id ?
                      (<TableCell style={{ width: '0%' }}>
                        <Tooltip title="Удалить Копию">
                          <IconButton
                            onClick={() => {
                              deleteCopyTaskHandler(dateTimeTask.id);
                            }}
                          >
                            <RemoveIcon />
                          </IconButton>
                        </Tooltip>
                      </TableCell>) : null}
                  </TableRow>
                ))}
              </TableBody>
            </Table>
          </Box>
        </Collapse>
      </TableCell>
    </TableRow>);
}

export default memo(TableForCopiesTasks)