import { Button } from "@mui/material";
import { memo } from "react";
import CustomAutocomplete from '../../../UI/CustomAutocomplete/CustomAutocomplete'


function CalendarModalWorkerContent({ allUserProjects, onChangeProjectHandler, onChangeWorkerHandler, workerInfo, workers, handleClose, onChangeCalendarUser }) {
  return (<>
    <CustomAutocomplete
      name={'project'}
      label={'Проекты'}
      options={allUserProjects}
      onChange={onChangeProjectHandler}
      value={workerInfo.project}
      getOptionLabel={(item) => item.title || ""}
      style={{ marginBottom: '15px' }}
    />
    {workerInfo.project ?
      <>
        <CustomAutocomplete
          name={'worker'}
          label={'Участник'}
          options={workers}
          onChange={onChangeWorkerHandler}
          value={workerInfo.worker}
          getOptionLabel={(item) => item?.user?.displayName || ""}
          style={{ marginBottom: '15px' }}
        />
        <div style={{ display: 'flex', justifyContent: 'space-between', margin: '10px 0' }}>
          <Button onClick={() => { onChangeCalendarUser() }} >Выбрать</Button>
          <Button onClick={() => handleClose()}>Отмена</Button>
        </div>
      </>
      : null}

  </>);
}

export default memo(CalendarModalWorkerContent);