import express,{Router, Request, Response} from 'express';
import {User} from '../models/User';
import {myDataSource} from '../app-data-source';
import { nanoid } from 'nanoid';
import multer  from 'multer';
import path from 'path';
import {config} from "../config"
import { Project } from '../models/Project';
import { Member, MemberRole } from '../models/Member';
import { auth } from '../helpers';

const router:Router = express.Router();
const dataSource = myDataSource;


type DestinationCallback = (error: Error | null, destination: string) => void
type FileNameCallback = (error: Error | null, filename: string) => void

const storage = multer.diskStorage({
    destination: (req:Request, file: Express.Multer.File, cb:DestinationCallback) => {
        cb(null, config.uploadPath);
    },
    filename: (req:Request, file: Express.Multer.File, cb:FileNameCallback) => {
        cb(null, nanoid() + path.extname(file.originalname));
    }
})

const upload = multer({ storage })

//** return all users of DB */
router.get('/', async (req : Request, res : Response):Promise<object> => {
    try{
const users = await dataSource
.getRepository(User)
    .createQueryBuilder("user")
    .getMany()
return res.send({users})
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
}) 

 //** return displayName of user, requested by userId */
 router.get('/display-name/:userId', auth, async (req : Request, res : Response):Promise<object> => {
    try{
    const {userId} = req.params
    const displayName = await dataSource
        .createQueryBuilder()
        .select(['user.displayName'])
        .from(User, "user")
        .where("user.id = :userId", { userId })
        .getOne()
        if (!displayName) return res.status(404).send({message:'displayName not found'})
    return res.send(displayName)
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
})


//** return all users of DB */
router.get('/all-fields/', async (req : Request, res : Response):Promise<object> => {
    try{
    const users = await dataSource
        .getRepository(User)
        .find({
            relations:{
                members:{
                    project:true,
                    user:true
                },
            }
        })
    return res.send({users})
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
    })  


//** return displayName of user, requested by userId */
    router.get('/display-name/:userId',auth, async (req : Request, res : Response):Promise<object> => {
        try{
        const {userId} =req.params
        const displayName = await dataSource
            .createQueryBuilder()
            .select(['user.displayName'])
            .from(User, "user")
            .where("user.id = :userId", { userId })
            .getOne()
            if (!displayName) return res.status(404).send({message:'displayName not found'})
        return res.send({displayName})
    } catch(e) {
        return res.status(502).send({message:(e as Error).message})
    }
        }) 


/**create new user*/
router.post('/', upload.single("avatar"), async (req : Request, res : Response):Promise<object> => {
    try{
    const {name,surname,password,email, role} = req.body;
    const displayName = surname+' '+name[0]+'.'
    const user = new User();
    user.name = name;
    user.surname = surname;
    user.password = password;
    user.displayName= displayName;
    user.email = email;
    user.role = role;
    user.generateToken();
    await user.save();
    /**Создание проектов "Личные дела" и "Не определено" 
     * у только что созданого пользователя*/
    const newProject = new Project();
    newProject.title = 'Личные дела';
    newProject.color= '#f595ee';
    await newProject.save()
    const newMember = new Member();
    newMember.user = user;
    newMember.project = newProject;
    newMember.roleProject = MemberRole.ADMIN;
    await newMember.save();
    const notDefinedTaskProject = new Project();
    notDefinedTaskProject.title = 'Не определено';
    notDefinedTaskProject.color= '#03fcfc';
    await notDefinedTaskProject.save()
    const notDefinedTaskProjectMember = new Member();
    notDefinedTaskProjectMember.user = user;
    notDefinedTaskProjectMember.project = notDefinedTaskProject;
    notDefinedTaskProjectMember.roleProject = MemberRole.ADMIN;
    await notDefinedTaskProjectMember.save();
    
    const userToFront:User|null = await dataSource.manager.findOneBy(User, {
        email: user.email
    })
    return res.send({userToFront})
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
}) 

/** log in*/ 
router.post('/sessions/', async (req : Request, res : Response):Promise<object> => {
    try{
    const {email, password} = req.body;
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.email = :email", { email: email })
    .addSelect('password')
    .getOne()
    if(!user) return res.status(404).send({Message:'user not found'})
    const isMatch:boolean = await user.checkPassword(password);
    if (!isMatch) return res.status(400).send({
        error: "Wrong Password"
    })
 
    const userToFront:User|null = await dataSource.manager.findOneBy(User, {
        email: req.body.email
    })
    return res.send({
                message: "message: 'Correct user  & password",
                user: userToFront
            })
        } catch(e) {
            return res.status(502).send({message:(e as Error).message})
        }
})

/** log out*/ 
router.delete('/sessions', async(req: Request, res: Response):Promise<void | object> => {
    try{
    const token = req.get('Authorization');
    const successMsg = {message:'success'};
    if(!token) return res.send(successMsg)
    const user = await dataSource.manager.findOneBy(User, {
        token: token
    })
    if(!user) return res.send({successMsg});
    user.token = nanoid();
    await user.save();
    return res.send(successMsg)
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
})



export default router;


