export const getDaysInMonth = (dateNow) => {
  const newDaysInMonth = []
  const daysInMonthNumber = new Date(dateNow.year, dateNow.month + 1, 0).getDate()
  for (let i = 1; i <= daysInMonthNumber; i++) {
    const dayOfWeekNumber = new Date(dateNow.year, dateNow.month, i).getDay()
    const getDayOfWeekString = ["ВС","ПН","ВТ","СР","ЧТ","ПТ","СБ"][dayOfWeekNumber]
    newDaysInMonth.push({dayNumber: i, dayOfWeek: getDayOfWeekString})
  }
  return newDaysInMonth
}

export const getCurrentMonthString = (dateNow) => {
  return ["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь", "Декабрь"][dateNow.month];
}

export const dateToISOLikeButLocal = (date) => {
  const offsetMs = date.getTimezoneOffset() * 60 * 1000;
  const msLocal =  date.getTime() - offsetMs;
  const dateLocal = new Date(msLocal);
  const iso = dateLocal.toISOString();
  return iso;
}