import { Button, Grid } from "@mui/material";
import FormElement from "../UI/Form/FormElement/FormElement";

const UserRegistrationForm = ({ state, onChange, onSubmit, getFieldError, buttonText, fileChangeHandler }) => {
    return <form onSubmit={onSubmit}>
        <Grid container spacing={2}>
            <FormElement
                onChange={onChange}
                name="name"
                label="Name"
                state={state}
                error={getFieldError?.("name")}
            />
             <FormElement
                onChange={onChange}
                name="surname"
                label="Surname"
                state={state}
                error={getFieldError?.("surname")}
            />
            <FormElement
                onChange={onChange}
                name="email"
                label="Email"
                state={state}
                error={getFieldError?.("email")}
            />
            {/* <FormElement
                onChange={onChange}
                name="number"
                label="Number"
                state={state}
                error={getFieldError?.("number")}
            /> */}
            <FormElement
                onChange={onChange}
                name="password"
                label="Password"
                type="password"
                state={state}
                error={getFieldError?.("password")}
            />
             <FormElement
                onChange={onChange}
                name="confirmPassword"
                label="Confirm password"
                type="password"
                state={state}
                error={getFieldError?.("password")}
            />
            {/* <FormElement
                onChange={fileChangeHandler}
                name="avatar"
                label="Avatar"
                type="file"
                state={state}
            /> */}
        </Grid>
        <Button
            sx={{ mt: "15px" }}
            type="submit"
            fullWidth
            variant="contained"
            color="primary"
        >
            {buttonText}
        </Button>
    </form>
}

export default UserRegistrationForm;