import {Button, Grid} from "@mui/material";
import {useState} from "react";
import { useSelector } from "react-redux";
import FormElement from "../UI/Form/FormElement/FormElement";

const ProjectForm = ({onSubmit}) => {
    const users = useSelector(state => state.users)
    console.log(users)
    const [state, setState] = useState({
        title: "",
        color: ""
    });


    const submitFormHandler = (e) => {
        e.preventDefault();
        let project = {title: state.title, color: state.color}
        console.log(project);
        onSubmit(project);
    };

    const inputChangeHandler = (e) => {
        const {name, value} = e.target;
        setState(prevState => {
            return {...prevState, [name]: value};
        });
    };

    return <form onSubmit={submitFormHandler}>
        <Grid container direction="column" spacing={2}>
            <FormElement 
            onChange={inputChangeHandler} 
            name={"title"} 
            label={"Title"} 
            state={state}  
            />
              <FormElement 
            onChange={inputChangeHandler} 
            name={"color"} 
            label={"Color"} 
            state={state}  
            />
            <Grid item>
                <Button
                    type="submit"
                    color="primary"
                    variant="contained"
                >
                    Create
                </Button>
            </Grid>
        </Grid>
    </form>
};

export default ProjectForm;