import { Modal, IconButton } from "@mui/material";
import "./TaskModal.css";
import { Done } from "@mui/icons-material";
import Input from "@mui/material/Input";

const TaskModal = ({handleClose,open,task,onChange,user }) => {

  return (
    <Modal
      aria-labelledby="transition-modal-title"
      aria-describedby="transition-modal-description"
      className={"modal"}
      closeAfterTransition
      onClose={handleClose}
      open={open}
    >
      {task?.isEditMode && task.author.id===user.id ? (
        <div className="modalBox">
          <Input
            value={task.title}
            name="title"
            onChange={(e) => onChange(e, task)}
            style={{
              width: "auto",
              fontSize: "12px",
              color: "white",
              fontWeight: "600",
            }}
          />
          <Input
            value={task.description}
            name="description"
            onChange={(e) => onChange(e, task)}
            style={{ width: "auto", fontSize: "12px", color: "white" }}
          />
          <IconButton aria-label="done" onClick={handleClose}>
            <Done />
          </IconButton>
        </div>
      ) : (
        <div className="modalBox">
          {task && task.title && (
            <div
              style={{
                width: "200px",
                height: "200px",
                color: "white",
                fontWeight: "600",
              }}
            >
              {task.title}
            </div>
          )}
          {task && task.description && (
            <div style={{ width: "200px", height: "200px", color: "white" }}>
              {task.description}
            </div>
          )}
          <IconButton
            sx={{ marginLeft: 0, color: "white" }}
            aria-label="close"
            onClick={handleClose}
          >
            X
          </IconButton>
        </div>
      )}
    </Modal>
  );
};

export default TaskModal;
