import { AppBar, Toolbar} from '@mui/material';
import { Box } from '@mui/system';
import MonthAndYearInfo from './MonthAndYearInfo/MonthAndYearInfo';
import СustomSelect from '../UI/СustomSelect/СustomSelect'

const workers = [{value: '', text: '--выберите сотрудника--'}, {value: 'Василий', text: 'Василий'}, {value: 'Никита', text: 'Никита'}]
const types = [{value: 'Месяц', text: 'Месяц'}, {value: 'Неделя', text: 'Неделя'}]

function MonthCalendarHeader({ currentMonthString, decrementMonth, incrementMonth, calendarType, onChangeWorkerHandler, onChangeCalendarTypeHandler, worker, year}) {
  
  return (
    <>
        <Box sx={{ flexGrow: 1 }}>
          <AppBar position="static">
            <Toolbar>
              
              <MonthAndYearInfo
                currentMonthString={currentMonthString}
                decrementMonth={decrementMonth}
                incrementMonth={incrementMonth}
                year={year}
              />
              <СustomSelect
                value={worker}
                onChange={(e)=>{onChangeWorkerHandler(e)}}
                label={'Сотрудник'}
                id={'worker'}
                items={workers}
              />
            <div style={{marginLeft: '20px'}}>
              <СustomSelect
                value={calendarType}
                onChange={(e)=>{onChangeCalendarTypeHandler(e)}}
                label={'Календарь'}
                id={'calendar-type'}
                items={types}
              />
            </div>
            </Toolbar>
          </AppBar>
        </Box>
    </>
  );
}

export default MonthCalendarHeader;