import express, { Express } from 'express';
import cors from 'cors';
import users from './routers/users';
import tasks from './routers/tasks';
import projects from './routers/projects';
import {myDataSource} from './app-data-source';
import copyTasks from './routers/copyTasks';


myDataSource
.initialize()
.then(() => {
    console.log("Data Source has been initialized!")
})
.catch((err) => {
    console.error("Error during Data Source initialization:", err)
})

const app:Express = express();
app.use(express.static('public'));
app.use(cors())
app.use(express.json());
const PORT = 8000;
app.use('/users',users)
app.use('/tasks',tasks)
app.use('/copy-tasks',copyTasks)
app.use('/projects',projects)

const run = async() => {
    
    
    app.listen(PORT, () => {
        console.log(`Server started at http://localhost:${PORT}/`);
    })

}

console.log('Hello world!');
run().catch(console.error);