import express,{Router, Request, Response,NextFunction } from 'express';
import {Task} from '../models/Task';
import {myDataSource} from '../app-data-source';
import { User } from '../models/User';
import { Member } from '../models/Member';
import { In } from 'typeorm';
import { DateTimeTask } from '../models/DateTimeTask';
import { auth, authAuthorOrExecutorOfTask } from '../helpers';
const router:Router = express.Router();
const dataSource = myDataSource;

/**task finder by id, return one task */
const taskFinderById = async (taskId:string):Promise<null | Task>=>{
    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,
            dateTimeTasks:true
        },
        where:{
            id:taskId
        }
    })
    
    return task
}

/** make copy of task in calendar view */
router.post("/make-copy",authAuthorOrExecutorOfTask, async(req:Request, res:Response):Promise<Response>=>{
    const {executorStatus,taskId,start, due} = req.body
    if (executorStatus){
        const newDateTimeTask = new DateTimeTask();
        newDateTimeTask.dateTimeStart = start
        newDateTimeTask.dateTimeDue = due
        newDateTimeTask.task = taskId
        await newDateTimeTask.save()
        const task = taskFinderById(taskId)
        return res.send({task})
    }
    return res.send({message :"Something wrong in make-copy router"})
} )

/** change date time of copy of task in calendar view */
router.put("change-copy", authAuthorOrExecutorOfTask, async(req:Request, res: Response):Promise<Response>=>{
    const {executorStatus,dateTimeTaskId,taskId, start, due} = req.body
    if (executorStatus){
        const dateTimeTask = await dataSource
        .createQueryBuilder()
        .select('dateTikeTask')
        .from(DateTimeTask,'dateTimeTask')
        .where("dateTimeTask.id = :dateTimeTaskId",{dateTimeTaskId})
        .getOne()
        if(!dateTimeTask) return res.send({message:"such dateTimeTask does not exists"})
        dateTimeTask.dateTimeStart=start
        dateTimeTask.dateTimeDue=due
        await dateTimeTask.save()
        const task = taskFinderById(taskId)
        return res.send({task})
    }
    return res.send({message :"Something wrong in make-copy router"})
})

export default router;
